/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.OverlaysRegister;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.event.ModEventFactory;
import net.kapitencraft.kap_lib.event.custom.client.RegisterConfigurableOverlaysEvent;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.extensions.IHolderExtension;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public class OverlayManager {
    private static final Codec<OverlayManager> CODEC = RecordCodecBuilder.create(renderControllerInstance -> renderControllerInstance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, OverlayProperties.CODEC).fieldOf("storage").forGetter(OverlayManager::getLocations)).apply((Applicative)renderControllerInstance, OverlayManager::fromCodec));
    private static File PERSISTENT_FILE;
    private final Map<Holder<OverlayProperties>, Function<OverlayProperties, Overlay>> constructors = new HashMap<Holder<OverlayProperties>, Function<OverlayProperties, Overlay>>();
    public final Map<Holder<OverlayProperties>, Overlay> map = new HashMap<Holder<OverlayProperties>, Overlay>();
    private final List<Overlay> visible = new ArrayList<Overlay>();
    private final List<Overlay> invisible = new ArrayList<Overlay>();
    private final Map<ResourceLocation, OverlayProperties> loadedPositions = new HashMap<ResourceLocation, OverlayProperties>();

    private static OverlayManager fromCodec(Map<ResourceLocation, OverlayProperties> map) {
        OverlayManager controller = new OverlayManager();
        controller.loadedPositions.putAll(map);
        return controller;
    }

    public static void setVisible(Overlay overlay, boolean b) {
        OverlayManager manager = LibClient.overlays;
        if (b) {
            manager.visible.add(overlay);
            manager.invisible.remove(overlay);
        } else {
            manager.invisible.add(overlay);
            manager.visible.remove(overlay);
        }
    }

    private Map<ResourceLocation, OverlayProperties> getLocations() {
        return MapStream.of(this.map).mapValues(Overlay::getProperties).mapKeys(IHolderExtension::getKey).mapKeys(ResourceKey::location).toMap();
    }

    @NotNull
    private static File getOrCreateFile() {
        if (PERSISTENT_FILE == null) {
            PERSISTENT_FILE = new File(KapLibMod.ROOT, "overlay_config.json");
        }
        return PERSISTENT_FILE;
    }

    public static OverlayManager load() {
        return IOHelper.loadFile(OverlayManager.getOrCreateFile(), CODEC, OverlayManager::new);
    }

    private OverlayManager() {
        this.register();
    }

    private void register() {
        OverlaysRegister.register(this);
        ModEventFactory.fireModEvent(new RegisterConfigurableOverlaysEvent(this::createRenderer));
        this.construct();
    }

    void createRenderer(Holder<OverlayProperties> provider, Function<OverlayProperties, Overlay> constructor) {
        if (this.constructors.containsKey(provider)) {
            throw new IllegalStateException("detected double registered Overlay with ID '" + String.valueOf(provider.getKey().location()) + "'");
        }
        this.constructors.put(provider, constructor);
    }

    public static void save() {
        IOHelper.saveFile(OverlayManager.getOrCreateFile(), CODEC, LibClient.overlays);
    }

    @SubscribeEvent
    public static void overlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(KapLibMod.res("overlay"), LibClient.overlays::render);
    }

    public void fillRenderBoxes(Consumer<ResizeBox> acceptor, BiConsumer<Overlay, ResizeBox> map, LocalPlayer player, Font font, float width, float height) {
        this.visible.forEach(overlay -> {
            ResizeBox box = overlay.newBox(width, height, player, font);
            acceptor.accept(box);
            map.accept((Overlay)overlay, box);
        });
    }

    private void render(GuiGraphics graphics, DeltaTracker tracker) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        int screenWidth = window.getGuiScaledWidth();
        int screenHeight = window.getGuiScaledHeight();
        LocalPlayer entity = minecraft.player;
        if (entity != null && !ClientHelper.hideGui()) {
            this.visible.forEach(renderHolder -> {
                graphics.pose().pushPose();
                OverlayProperties holder = renderHolder.getProperties();
                Vec2 renderLocation = renderHolder.getLoc(screenWidth, screenHeight);
                graphics.pose().translate(renderLocation.x, renderLocation.y, 0.0f);
                graphics.pose().scale(holder.getXScale(), holder.getYScale(), 0.0f);
                renderHolder.render(minecraft.gui, graphics, screenWidth, screenHeight, entity);
                graphics.pose().popPose();
            });
        }
    }

    private void construct() {
        this.constructors.forEach((location, constructor) -> {
            OverlayProperties holder = MiscHelper.nonNullOr(this.loadedPositions.get(location.getKey().location()), ((OverlayProperties)location.value()).createCopy());
            Overlay overlay = (Overlay)constructor.apply(holder);
            if (holder.isVisible()) {
                this.visible.add(overlay);
            } else {
                this.invisible.add(overlay);
            }
            this.map.put((Holder<OverlayProperties>)location, overlay);
        });
    }

    public void reset(Overlay dedicatedHolder) {
        if (this.map.containsValue(dedicatedHolder)) {
            if (this.invisible.contains(dedicatedHolder)) {
                this.invisible.remove(dedicatedHolder);
                this.visible.add(dedicatedHolder);
            }
            Holder<OverlayProperties> location = CollectionHelper.getKeyForValue(this.map, dedicatedHolder);
            dedicatedHolder.getProperties().copy((OverlayProperties)location.value());
            return;
        }
        throw new IllegalStateException("attempted to reset non-existing Holder");
    }

    public static void resetAll() {
        OverlayManager controller = LibClient.overlays;
        Set<Holder<OverlayProperties>> locations = controller.constructors.keySet();
        locations.forEach(location -> {
            Overlay holder = controller.map.get(location);
            holder.getProperties().copy((OverlayProperties)location.value());
            controller.visible.add(holder);
        });
        controller.invisible.clear();
    }
}

