/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTriggerInstance;
import net.minecraft.CrashReport;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.ApiStatus;

public class ParticleAnimator {
    private final ParticleAnimation animation;
    private final List<ParticleConfig> particles = new ArrayList<ParticleConfig>();
    private final ParticleSpawnSink sink = new ParticleSpawnSink(this);
    public int runningTicks;
    private int currentSpawnDelay;

    @ApiStatus.Internal
    public ParticleAnimator(ParticleAnimation animation) {
        this.animation = animation;
        List<TerminationTriggerInstance> terminators = animation.getTerminators();
        for (TerminationTriggerInstance terminator : terminators) {
            TerminationTrigger<? extends TerminationTriggerInstance> trigger = terminator.getTrigger();
            trigger.addListener(this, new TerminationTrigger.Listener<TerminationTriggerInstance>(terminator, this));
        }
    }

    @ApiStatus.Internal
    public void addParticle(Particle particle) {
        this.particles.add(new ParticleConfig(particle, this.animation));
    }

    @ApiStatus.Internal
    public void tick(RandomSource source) {
        if (this.currentSpawnDelay == 0) {
            this.animation.spawnTick(this.sink);
            this.currentSpawnDelay = Mth.randomBetweenInclusive((RandomSource)source, (int)this.animation.minSpawnDelay, (int)this.animation.maxSpawnDelay);
        }
        --this.currentSpawnDelay;
        List<ParticleConfig> expired = this.particles.stream().filter(ParticleConfig::hasExpired).toList();
        expired.forEach(ParticleConfig::invalidate);
        this.particles.removeAll(expired);
        this.particles.forEach(ParticleConfig::tick);
        ++this.runningTicks;
    }

    public void fillCrashReport(CrashReport report) {
        report.addCategory("Animator").setDetail("runningTicks", (Object)this.runningTicks).setDetail("currentSpawnDelay", (Object)this.currentSpawnDelay).setDetail("Particles", this.particles);
        this.animation.fillCrashReport(report);
    }
}

