/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class RotateElement
implements AnimationElement {
    private final PositionTarget pivot;
    private final float degreePerTick;
    private final int duration;
    private final Direction.Axis axis;

    public RotateElement(PositionTarget pivot, float degreePerTick, int duration, Direction.Axis axis) {
        this.pivot = pivot;
        this.degreePerTick = degreePerTick;
        this.duration = duration;
        this.axis = axis;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public AnimationElement.Type<? extends AnimationElement> getType() {
        return ElementTypes.ROTATE.get();
    }

    @Override
    public int createLength(ParticleConfig config) {
        return this.duration;
    }

    @Override
    public void tick(ParticleConfig object, int tick, double percentage) {
        object.setPos(MathHelper.rotateAroundAxis(object.pos(), this.pivot.get(), this.degreePerTick, this.axis));
    }

    public static class Builder
    implements AnimationElement.Builder {
        private PositionTarget pivot;
        private float angle;
        private int duration;
        private Direction.Axis axis;

        public Builder pivot(PositionTarget target) {
            this.pivot = target;
            return this;
        }

        public Builder axis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public Builder angle(float angle) {
            this.angle = angle;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public AnimationElement build() {
            return new RotateElement(this.pivot, this.angle, this.duration, this.axis);
        }
    }

    public static class Type
    implements AnimationElement.Type<RotateElement> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, RotateElement> STREAM_CODEC = StreamCodec.composite(PositionTarget.STREAM_CODEC, e -> e.pivot, (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.degreePerTick), (StreamCodec)ByteBufCodecs.INT, e -> e.duration, (StreamCodec)ExtraStreamCodecs.enumCodec((Enum[])Direction.Axis.values()), e -> e.axis, RotateElement::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, RotateElement> codec() {
            return STREAM_CODEC;
        }
    }
}

