/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.select;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.kapitencraft.kap_lib.client.BannerPatternRenderer;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.client.widget.select.MultiElementSelectorWidget;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class CreateBannerWidget
extends PositionedWidget {
    private static final List<DyeColor> lights = List.of(DyeColor.WHITE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.LIGHT_BLUE);
    private final List<PositionedWidget> widgets = new ArrayList<PositionedWidget>();
    private final VisualPatternBuilder builder;
    private final SelectDyeColorWidget selectDyeColorWidget;

    public CreateBannerWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.selectDyeColorWidget = new SelectDyeColorWidget(this.x + 1, this.y + 1, 2, height);
        this.widgets.add(this.selectDyeColorWidget);
        int xStart1 = this.x + 2 + this.selectDyeColorWidget.width;
        SelectBannerPatternWidget selectBannerPatternWidget = new SelectBannerPatternWidget(xStart1, this.y + 1, 4, height);
        this.widgets.add(selectBannerPatternWidget);
        this.builder = new VisualPatternBuilder(xStart1 + 57, this.y + 1, height, List.of());
        this.widgets.add(this.builder);
    }

    public ItemStack getBanner() {
        return this.builder.createBanner();
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.widgets.forEach(positionedWidget -> positionedWidget.render(graphics, pMouseX, pMouseY, pPartialTick));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        return this.widgets.stream().anyMatch(positionedWidget -> positionedWidget.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return this.widgets.stream().anyMatch(positionedWidget -> positionedWidget.mouseClicked(pMouseX, pMouseY, pButton));
    }

    private static class SelectDyeColorWidget
    extends MultiElementSelectorWidget<DyeColor> {
        public SelectDyeColorWidget(int x, int y, int width, int height) {
            super(x, y, width, 16, height, List.of(DyeColor.values()));
            this.active = DyeColor.WHITE;
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, DyeColor element) {
            adder.accept(new MultiElementSelectorWidget.ElementButton(this, xStart, yStart, 16, element, Color.fromARGBPacked(element.getTextColor()).setAlpha(255.0f).pack()));
        }
    }

    private class SelectBannerPatternWidget
    extends MultiElementSelectorWidget<Holder<BannerPattern>> {
        public SelectBannerPatternWidget(int x, int y, int width, int height) {
            super(x, y, width, 14, height, SelectBannerPatternWidget.getElements());
            this.active = null;
        }

        private static List<Holder<BannerPattern>> getElements() {
            HolderLookup.RegistryLookup lookup = Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN);
            return lookup.listElements().collect(Collectors.toUnmodifiableList());
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, Holder<BannerPattern> element) {
            adder.accept(new Element(xStart, yStart, element));
        }

        private class Element
        extends MultiElementSelectorWidget.ElementButton {
            private final ModelPart flag;

            protected Element(int x, int y, Holder<BannerPattern> own) {
                super(SelectBannerPatternWidget.this, x, y, 14, own, -1);
                this.flag = BannerPatternRenderer.getFlag();
            }

            @Override
            public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                boolean flag = this.hovered(pMouseX, pMouseY);
                int j2 = 166;
                if (this.own == SelectBannerPatternWidget.this.active) {
                    j2 += 14;
                } else if (flag) {
                    j2 += 28;
                }
                int xOffset = this.getXOffset();
                int yOffset = this.getYOffset();
                graphics.blit(UsefulTextures.SLIDER, xOffset, yOffset, 0, j2, 14, 14);
                this.renderPattern((DyeColor)CreateBannerWidget.this.selectDyeColorWidget.active);
            }

            @Override
            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                if (this.hovered(pMouseX, pMouseY)) {
                    CreateBannerWidget widget = CreateBannerWidget.this;
                    if (((Holder)this.own).is(BannerPatterns.BASE)) {
                        widget.builder.background = (DyeColor)widget.selectDyeColorWidget.active;
                        return true;
                    }
                    return widget.builder.addPattern((Holder<BannerPattern>)((Holder)this.own), (DyeColor)widget.selectDyeColorWidget.active);
                }
                return false;
            }

            @Contract(value="null -> fail")
            private void renderPattern(DyeColor color) {
                CompoundTag compoundtag = new CompoundTag();
                BannerPatternLayers layers = new BannerPatternLayers.Builder().add((Holder)this.own, color).build();
                ItemStack itemstack = new ItemStack((ItemLike)(lights.contains(color) ? Items.GRAY_BANNER : Items.WHITE_BANNER));
                BlockItem.setBlockEntityData((ItemStack)itemstack, (BlockEntityType)BlockEntityType.BANNER, (CompoundTag)compoundtag);
                PoseStack posestack = new PoseStack();
                posestack.pushPose();
                posestack.translate((float)this.getXOffset() + 0.5f, (float)(this.getYOffset() + 16), 0.0f);
                posestack.scale(6.0f, -6.0f, 1.0f);
                posestack.translate(0.5f, 0.5f, 0.0f);
                posestack.translate(0.5f, 0.5f, 0.0f);
                float f = 0.6666667f;
                posestack.scale(f, -f, -f);
                MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
                BannerRenderer.renderPatterns((PoseStack)posestack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.GRAY, (BannerPatternLayers)layers);
                posestack.popPose();
                source.endBatch();
            }
        }
    }

    private static class VisualPatternBuilder
    extends MultiElementSelectorWidget<Pair<Holder<BannerPattern>, DyeColor>> {
        private final ModelPart flag = BannerPatternRenderer.getFlag();
        private DyeColor background = DyeColor.WHITE;
        private int ySpawnOffset = 0;
        private static final Collector<Pair<Holder<BannerPattern>, DyeColor>, BannerPatternLayers.Builder, BannerPatternLayers> COLLECTOR = Collector.of(BannerPatternLayers.Builder::new, (builder1, holderDyeColorPair) -> builder1.add((Holder)holderDyeColorPair.getFirst(), (DyeColor)holderDyeColorPair.getSecond()), (builder1, builder2) -> {
            builder1.addAll(builder2.build());
            return builder1;
        }, BannerPatternLayers.Builder::build, new Collector.Characteristics[0]);

        public VisualPatternBuilder(int x, int y, int height, List<Pair<Holder<BannerPattern>, DyeColor>> elements) {
            super(x, y, 1, 14, height, elements);
        }

        public boolean addPattern(Holder<BannerPattern> pBannerPattern, DyeColor pColor) {
            return this.addPattern((Pair<Holder<BannerPattern>, DyeColor>)Pair.of(pBannerPattern, (Object)pColor));
        }

        public boolean addPattern(Pair<Holder<BannerPattern>, DyeColor> pPattern) {
            if (this.buttons.size() == 17) {
                return false;
            }
            this.buttons.add(new PatternElement(this.x, this.y + this.ySpawnOffset, pPattern));
            this.ySpawnOffset += 14;
            this.allElementsSize += 14;
            return true;
        }

        public boolean movePattern(@Range(from=0L, to=0x7FFFFFFFL) int moveIndex, boolean up) {
            if (this.buttons.isEmpty() || up && moveIndex == 0 || !up && moveIndex + 1 == this.buttons.size()) {
                return false;
            }
            PatternElement pattern = (PatternElement)this.buttons.remove(moveIndex);
            if (up) {
                this.buttons.add(--moveIndex, pattern);
            } else {
                this.buttons.add(++moveIndex, pattern);
            }
            this.reapplyYPos();
            return true;
        }

        public void removePattern(int removeLoc) {
            this.buttons.remove(removeLoc);
            this.ySpawnOffset -= 14;
        }

        private void moveAllUp(int startId, int endId) {
            for (int i = startId; i <= endId; ++i) {
                this.moveUp(i);
            }
        }

        private void moveUp(int elementId) {
            ((MultiElementSelectorWidget.ElementButton)this.buttons.get(elementId)).move(-14);
        }

        private void reapplyYPos() {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ((MultiElementSelectorWidget.ElementButton)this.buttons.get((int)i)).y = this.y + i * 14;
            }
        }

        @Override
        protected void createElement(Consumer<MultiElementSelectorWidget.ElementButton> adder, int xStart, int yStart, int elementSize, Pair<Holder<BannerPattern>, DyeColor> element) {
            adder.accept(new PatternElement(this.x, this.y, element));
        }

        @Override
        public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.render(graphics, pMouseX, pMouseY, pPartialTick);
            BannerPatternLayers layers = this.bakePatterns();
            BannerPatternRenderer.renderBanner(graphics, this.x + 10, this.y + 1, layers, this.background, this.height - 2);
        }

        private BannerPatternLayers bakePatterns() {
            return this.buttons.stream().map(elementButton -> (Pair)elementButton.own).collect(COLLECTOR);
        }

        @Contract(value="null, _, _, _ -> fail; _, _, _, null -> fail")
        private void renderPattern(Holder<BannerPattern> pPattern, int pX, int pY, DyeColor color) {
            BannerPatternLayers layers = new BannerPatternLayers.Builder().add(pPattern, color).build();
            PoseStack posestack = new PoseStack();
            posestack.pushPose();
            posestack.translate((float)pX + 0.5f, (float)(pY + 16), 0.0f);
            posestack.scale(6.0f, -6.0f, 1.0f);
            posestack.translate(0.5f, 0.5f, 0.0f);
            posestack.translate(0.5f, 0.5f, 0.0f);
            float f = 0.6666667f;
            posestack.scale(f, -f, -f);
            MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
            BannerRenderer.renderPatterns((PoseStack)posestack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.GRAY, (BannerPatternLayers)layers);
            posestack.popPose();
            source.endBatch();
        }

        public ItemStack createBanner() {
            ItemStack stack = new ItemStack((ItemLike)VisualPatternBuilder.getBannerItem(this.background));
            stack.set(DataComponents.BANNER_PATTERNS, (Object)this.bakePatterns());
            return stack;
        }

        private static Item getBannerItem(DyeColor color) {
            return switch (color) {
                default -> throw new MatchException(null, null);
                case DyeColor.LIME -> Items.LIME_BANNER;
                case DyeColor.YELLOW -> Items.YELLOW_BANNER;
                case DyeColor.WHITE -> Items.WHITE_BANNER;
                case DyeColor.RED -> Items.RED_BANNER;
                case DyeColor.BLACK -> Items.BLACK_BANNER;
                case DyeColor.BLUE -> Items.BLUE_BANNER;
                case DyeColor.CYAN -> Items.CYAN_BANNER;
                case DyeColor.GRAY -> Items.GRAY_BANNER;
                case DyeColor.PINK -> Items.PINK_BANNER;
                case DyeColor.BROWN -> Items.BROWN_BANNER;
                case DyeColor.GREEN -> Items.GREEN_BANNER;
                case DyeColor.ORANGE -> Items.ORANGE_BANNER;
                case DyeColor.PURPLE -> Items.PURPLE_BANNER;
                case DyeColor.MAGENTA -> Items.MAGENTA_BANNER;
                case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_BANNER;
                case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_BANNER;
            };
        }

        private class PatternElement
        extends MultiElementSelectorWidget.ElementButton {
            protected PatternElement(int x, int y, Pair<Holder<BannerPattern>, DyeColor> own) {
                super(VisualPatternBuilder.this, x, y, 14, own, -1);
            }

            @Override
            public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)UsefulTextures.SLIDER);
                boolean flag = MathHelper.is2dBetween(pMouseX, pMouseY, this.x, this.y, this.x + 14, this.y + 14);
                int j2 = 166;
                if (flag) {
                    j2 += 28;
                }
                int xOffset = this.getXOffset();
                int yOffset = this.getYOffset();
                graphics.blit(UsefulTextures.SLIDER, xOffset, yOffset, 0, j2, 14, 14);
                VisualPatternBuilder.this.renderPattern((Holder<BannerPattern>)((Holder)((Pair)this.own).getFirst()), xOffset, yOffset, (DyeColor)((Pair)this.own).getSecond());
                if (flag) {
                    UsefulTextures.renderCross(graphics, xOffset, yOffset + 7, 7);
                    int index = VisualPatternBuilder.this.buttons.indexOf(this);
                    if (index != 0) {
                        UsefulTextures.renderUpButton(graphics, xOffset + 7, yOffset, MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 7, this.y, this.x + 14, this.y + 7), 7);
                    }
                    if (index != VisualPatternBuilder.this.buttons.size() - 1) {
                        UsefulTextures.renderDownButton(graphics, xOffset + 7, yOffset + 7, MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 7, this.y + 7, this.x + 14, this.y + 14), 7);
                    }
                }
            }

            @Override
            public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
                if (this.hovered(pMouseX, pMouseY)) {
                    double relativeX = pMouseX - (double)this.x;
                    double relativeY = pMouseY - (double)this.y;
                    List list = VisualPatternBuilder.this.buttons;
                    int index = list.indexOf(this);
                    if (relativeX < 7.0) {
                        if (relativeY >= 7.0) {
                            VisualPatternBuilder.this.removePattern(index);
                            VisualPatternBuilder.this.moveAllUp(index, list.size() - 1);
                        }
                    } else {
                        boolean ignored = VisualPatternBuilder.this.movePattern(index, relativeY < 7.0);
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

