/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.ExtraComponents;
import net.kapitencraft.kap_lib.client.particle.animation.AnimationUtils;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.elements.KeepAliveElement;
import net.kapitencraft.kap_lib.client.particle.animation.elements.MoveAwayElement;
import net.kapitencraft.kap_lib.client.particle.animation.elements.RotateElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.RemoveParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.SetLifeTimeFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.LineSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.RingSpawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.TimedTerminator;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.client.util.rot_target.RotationTarget;
import net.kapitencraft.kap_lib.data_gen.TestSpawnTableProvider;
import net.kapitencraft.kap_lib.helpers.CommandHelper;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.util.attribute.TimedModifierUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ServerTestCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"server_test").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animation").then(Commands.literal((String)"rotation").executes(ServerTestCommand::testRotation))).then(Commands.literal((String)"arrow").executes(ServerTestCommand::testArrow))).then(Commands.literal((String)"aura").executes(ServerTestCommand::testAura))).then(Commands.literal((String)"star").executes(ServerTestCommand::testStar))).then(Commands.literal((String)"line").executes(ServerTestCommand::testLine)))).then(Commands.literal((String)"spawn_table").executes(ServerTestCommand::testSpawnTable))).then(Commands.literal((String)"player_head").executes(ServerTestCommand::testPlayerHeadGlyph))).then(Commands.literal((String)"tooltip").executes(ServerTestCommand::testLargeTooltip))).then(Commands.literal((String)"timed_modifier").executes(ServerTestCommand::testTimedModifier)));
    }

    private static int testTimedModifier(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            TimedModifierUtils.add((LivingEntity)player, KapLibMod.res("test"), 400, (Holder<Attribute>)Attributes.MAX_HEALTH, 4.0, AttributeModifier.Operation.ADD_VALUE);
            return 1;
        });
    }

    private static int testLargeTooltip(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND);
            List<String> loreData = List.of("Minecraft is a 2011 sandbox game developed and published by the Swedish video game developer Mojang Studios.", "Originally created by Markus \"Notch\" Persson using the Java programming language, the first public alpha build was released on 17 May 2009.", "The game was continuously developed from then on, receiving a full release on 18 November 2011.", "Afterwards, Persson left Mojang and gave Jens \"Jeb\" Bergensten control over development.", "In the years since its release, it has been ported to several platforms, including smartphones, tablets, and various video game consoles.", "In 2014, Mojang and the Minecraft intellectual property were purchased by Microsoft for US$2.5 billion.", "", "In Minecraft, players explore a procedurally generated, three-dimensional world with virtually infinite terrain made up of voxels.", "Players can discover and extract raw materials, craft tools and items, and build structures, earthworks, and machines.", "Depending on their chosen game mode, players can fight hostile mobs, as well as cooperate with or compete against other players in multiplayer.", "The game has two main modes: Survival mode, where players must acquire resources to survive, and Creative mode, where players have unlimited resources and the ability to fly.", "The game can be further interacted with through Hardcore mode, a permadeath variant of Survival, as well as player-made downloadable maps or self-imposed challenges.", "The game's large community offers a wide variety of user-generated content, such as modifications, servers, player skins, texture packs, and custom maps, which add new game mechanics and possibilities.", "Speedrunning is another popular community activity.", "", "Minecraft is the best-selling video game of all time, with over 350 million copies sold and nearly 170 million monthly active players as of 2025.", "In addition, it has received critical acclaim, winning several awards and being cited as one of the greatest video games of all time;", "social media, parodies, adaptations, merchandise, and the annual Minecon conventions have played prominent roles in popularizing the game.", "Minecraft has been used in educational environments to teach chemistry, computer-aided design, and computer science.", "The wider Minecraft franchise includes several spin-off games including Minecraft: Story Mode, Minecraft Earth, Minecraft Dungeons, and Minecraft Legends.", "A live-action film adaptation, titled A Minecraft Movie, was released in theatres on 4 April 2025. ");
            List list = loreData.stream().map(Component::literal).collect(Collectors.toUnmodifiableList());
            stack.set(DataComponents.LORE, (Object)new ItemLore(list));
            player.addItem(stack);
            return 1;
        });
    }

    private static int testPlayerHeadGlyph(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            MinecraftServer server = Objects.requireNonNull(player.getServer());
            List players = server.getPlayerList().getPlayers();
            MutableComponent text = Component.empty();
            for (ServerPlayer p : players) {
                text.append((Component)ExtraComponents.playerHead(p.getUUID()));
            }
            player.sendSystemMessage((Component)text);
            return 1;
        });
    }

    private static int testSpawnTable(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            LootParams params = new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)commandSourceStack.getPosition()).withParameter(LootContextParams.THIS_ENTITY, player).create(LootContextParamSets.COMMAND);
            SpawnContext spawnContext = new SpawnContext.Builder(params).create(null);
            Optional<SpawnTable> table = player.registryAccess().lookupOrThrow(ExtraRegistries.Keys.SPAWN_TABLES).get(TestSpawnTableProvider.TEST).map(Holder::value);
            if (table.isPresent()) {
                table.get().getRandomEntities(spawnContext, entity -> entity.setPos(commandSourceStack.getPosition()));
            } else {
                commandSourceStack.sendFailure((Component)Component.translatable((String)"command.server_test.spawn_table.not_found"));
            }
            return 1;
        });
    }

    private static int testStar(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            PositionTarget center = PositionTarget.fixed(player.position());
            AnimationUtils.star(5, (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (ParticleOptions)ParticleTypes.FLAME, 0.25f, 5.0f, center).terminatedWhen(TimedTerminator.ticks(600)).finalizes(RemoveParticleFinalizer.builder()).then(RotateElement.builder().angle(1.0f).axis(Direction.Axis.Y).pivot(center).duration(600)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testLine(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 pos = player.position();
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.once()).spawn((Spawner.Builder)LineSpawner.builder().start(PositionTarget.fixed(pos)).end(PositionTarget.fixed(pos.add(0.0, 10.0, 0.0))).spacing(0.25f).setParticle((ParticleOptions)ParticleTypes.FLAME)).terminatedWhen(TimedTerminator.seconds(10)).finalizes(RemoveParticleFinalizer.builder()).then(KeepAliveElement.forDuration(200)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testAura(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn(((RingSpawner.Builder)RingSpawner.entityWithBBSize((Entity)player, 1.7f, 1.0f).setParticle((ParticleOptions)ParticleTypes.FLAME)).rotPerTick(5.0f).heightPerTick(0.02f)).terminatedWhen(TimedTerminator.ticks(600)).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testArrow(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Arrow arrow = new Arrow(EntityType.ARROW, player.level());
            arrow.setPos(player.position());
            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.5f, 0.0f);
            player.level().addFreshEntity((Entity)arrow);
            ParticleAnimation.requireEntity((Entity)arrow).spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn((Spawner.Builder)RingSpawner.noHeight().setTarget(PositionTarget.entity((Entity)arrow)).rotation(RotationTarget.forEntity((Entity)arrow)).spawnCount(2).rotPerTick(5.0f).axis(Direction.Axis.Z).radius(0.3f).setParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)0xFFFFFF).toVector3f(), 0.34f))).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testRotation(CommandContext<CommandSourceStack> context) {
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 playerPos = player.position();
            ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(RemoveParticleFinalizer.builder()).spawn((Spawner.Builder)RingSpawner.noHeight().axis(Direction.Axis.Y).radius(0.1f).rotPerTick(1.0f).setTarget(PositionTarget.fixed(playerPos)).setParticle((ParticleOptions)ParticleTypes.FLAME)).terminatedWhen(TimedTerminator.ticks(600)).then(MoveAwayElement.builder().speed(0.01f).time(20).target(PositionTarget.fixed(playerPos))).sendToPlayer((ServerPlayer)player);
            return 1;
        });
    }

    private static int testAnimation(CommandContext<CommandSourceStack> context) {
        int index = IntegerArgumentType.getInteger(context, (String)"testIndex");
        return CommandHelper.checkNonConsoleCommand(context, (player, commandSourceStack) -> {
            Vec3 playerPos = player.position();
            if (index != 0) {
                if (index == 1) {
                    ParticleAnimation.builder().spawnTime(ParticleAnimation.SpawnTime.absolute(1)).finalizes(SetLifeTimeFinalizer.builder().resetAge().lifeTime(20)).spawn(((RingSpawner.Builder)RingSpawner.entityWithBBSize((Entity)player, 1.7f, 1.0f).setParticle((ParticleOptions)ParticleTypes.FLAME)).rotPerTick(5.0f).heightPerTick(0.02f)).terminatedWhen(TimedTerminator.ticks(600)).sendToPlayer((ServerPlayer)player);
                } else if (index == 2) {
                    // empty if block
                }
            }
            return 1;
        });
    }
}

