/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.modifier_display;

import io.netty.buffer.ByteBuf;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.extensions.IAttributeExtension;
import org.jetbrains.annotations.NotNull;

public interface DisplayExtension<T> {
    default public Component createComponent(double value) {
        Type type = this.getType();
        if (type == Type.NONE) {
            return CommonComponents.EMPTY;
        }
        return Component.literal((String)(type.open + IAttributeExtension.FORMAT.format(value) + type.close)).withStyle(this.getStyle());
    }

    public ResourceLocation getModifiersLocation();

    public Style getStyle();

    public Type getType();

    public static enum Type implements StringRepresentable
    {
        NONE(' ', ' '),
        CURLY('{', '}'),
        SQUARE('[', ']'),
        DEFAULT('(', ')'),
        POINTY('<', '>');

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        private final char open;
        private final char close;

        private Type(char open, char close) {
            this.open = open;
            this.close = close;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            STREAM_CODEC = ExtraStreamCodecs.enumCodec((Enum[])Type.values());
        }
    }
}

