/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.event.custom.LivingStartGlidingEvent;
import net.kapitencraft.kap_lib.item.combat.LibSwordItem;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RegistryReqType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IPlayerExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements IPlayerExtension {
    @Shadow
    public abstract void increaseScore(int var1);

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @Shadow
    public abstract void playNotifySound(SoundEvent var1, SoundSource var2, float var3, float var4);

    @Shadow
    public abstract void playSound(SoundEvent var1, float var2, float var3);

    private Player self() {
        return (Player)this;
    }

    @Inject(method={"tryToStartFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkGlideAllowed(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = this.self().getItemBySlot(EquipmentSlot.CHEST);
        if (!RequirementManager.instance.meetsRequirements(RegistryReqType.ITEM, stack.getItem(), (LivingEntity)this.self())) {
            cir.setReturnValue((Object)false);
        }
        LivingStartGlidingEvent event = new LivingStartGlidingEvent((LivingEntity)this.self(), stack);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSources;playerAttack(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/damagesource/DamageSource;"))
    public DamageSource extendDamageSource(DamageSources instance, Player pPlayer) {
        ItemStack sword = pPlayer.getMainHandItem();
        Item item = sword.getItem();
        if (item instanceof LibSwordItem) {
            LibSwordItem libSwordItem = (LibSwordItem)item;
            return instance.source(libSwordItem.getDamageType(), (Entity)pPlayer);
        }
        return instance.playerAttack(pPlayer);
    }
}

