/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry.custom.spawn_table;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.AddEffectsFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.AddPassengersFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.CommonPropertiesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.MobPropertiesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.RaiderPropertiesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SequenceFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetAirSupplyFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetArmorFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetAttributesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetEntityOwnerFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetExperienceValueFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetFacingFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetFireFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetHealthFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetLeashedFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetMerchantTradesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetMotionFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.SetNameFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.VillagerPropertiesFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface SpawnEntityFunctions {
    public static final Codec<SpawnEntityFunction> TYPED_CODEC = ExtraRegistries.SPAWN_FUNCTION_TYPES.byNameCodec().dispatch("function", SpawnEntityFunction::getType, SpawnEntityFunctionType::codec);
    public static final Codec<SpawnEntityFunction> ROOT_CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, SequenceFunction.INLINE_CODEC));
    public static final DeferredRegister<SpawnEntityFunctionType<?>> REGISTRY = KapLibMod.registry(ExtraRegistries.Keys.FUNCTION_TYPES);
    public static final Supplier<SpawnEntityFunctionType<CommonPropertiesFunction>> COMMON_PROPERTIES = SpawnEntityFunctions.register("common_properties", CommonPropertiesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<MobPropertiesFunction>> MOB_PROPERTIES = SpawnEntityFunctions.register("mob_properties", MobPropertiesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<RaiderPropertiesFunction>> RAIDER_PROPERTIES = SpawnEntityFunctions.register("raider_properties", RaiderPropertiesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<VillagerPropertiesFunction>> VILLAGER_PROPERTIES = SpawnEntityFunctions.register("villager_properties", VillagerPropertiesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetNameFunction>> SET_NAME = SpawnEntityFunctions.register("set_name", SetNameFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetMotionFunction>> SET_MOTION = SpawnEntityFunctions.register("set_motion", SetMotionFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetFacingFunction>> SET_FACING = SpawnEntityFunctions.register("set_facing", SetFacingFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetFireFunction>> SET_FIRE_DURATION = SpawnEntityFunctions.register("set_fire", SetFireFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetAirSupplyFunction>> SET_AIR_SUPPLY = SpawnEntityFunctions.register("set_air_supply", SetAirSupplyFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetArmorFunction>> SET_ARMOR = SpawnEntityFunctions.register("set_armor", SetArmorFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetLeashedFunction>> SET_LEASHED = SpawnEntityFunctions.register("set_leashed", SetLeashedFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetHealthFunction>> SET_HEALTH = SpawnEntityFunctions.register("set_health", SetHealthFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetEntityOwnerFunction>> SET_OWNER = SpawnEntityFunctions.register("set_owner", SetEntityOwnerFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetExperienceValueFunction>> SET_EXPERIENCE_VALUE = SpawnEntityFunctions.register("set_experience_value", SetExperienceValueFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetAttributesFunction>> SET_ATTRIBUTES = SpawnEntityFunctions.register("set_attributes", SetAttributesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SetMerchantTradesFunction>> SET_MERCHANT_TRADES = SpawnEntityFunctions.register("set_merchant_trades", SetMerchantTradesFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<AddEffectsFunction>> ADD_EFFECTS = SpawnEntityFunctions.register("add_effects", AddEffectsFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<AddPassengersFunction>> ADD_PASSENGERS = SpawnEntityFunctions.register("add_passengers", AddPassengersFunction.CODEC);
    public static final Supplier<SpawnEntityFunctionType<SequenceFunction>> SEQUENCE = SpawnEntityFunctions.register("sequence", SequenceFunction.CODEC);
    public static final BiFunction<Entity, SpawnContext, Entity> IDENTITY = (p_80760_, p_80761_) -> p_80760_;

    public static <T extends SpawnEntityFunction> DeferredHolder<SpawnEntityFunctionType<?>, SpawnEntityFunctionType<T>> register(String name, MapCodec<T> serializer) {
        return REGISTRY.register(name, () -> new SpawnEntityFunctionType(serializer));
    }

    public static BiFunction<Entity, SpawnContext, Entity> compose(List<? extends BiFunction<Entity, SpawnContext, Entity>> pFunctions) {
        switch (pFunctions.size()) {
            case 0: {
                return IDENTITY;
            }
            case 1: {
                return pFunctions.getFirst();
            }
            case 2: {
                BiFunction<Entity, SpawnContext, Entity> bifunction = pFunctions.get(0);
                BiFunction<Entity, SpawnContext, Entity> bifunction1 = pFunctions.get(1);
                return (p_80768_, p_80769_) -> (Entity)bifunction1.apply((Entity)bifunction.apply((Entity)p_80768_, (SpawnContext)((Object)p_80769_)), (SpawnContext)((Object)p_80769_));
            }
        }
        return (p_80774_, p_80775_) -> {
            for (BiFunction bifunction2 : pFunctions) {
                p_80774_ = (Entity)bifunction2.apply(p_80774_, p_80775_);
            }
            return p_80774_;
        };
    }
}

