/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPool;
import net.kapitencraft.kap_lib.spawn_table.functions.core.FunctionUserBuilder;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SpawnTable {
    public static final LootContextParamSet DEFAULT_PARAM_SET = LootContextParamSets.ALL_PARAMS;
    public static final Codec<SpawnTable> DIRECT_CODEC = RecordCodecBuilder.create(p_338123_ -> p_338123_.group((App)LootContextParamSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(p_298001_ -> p_298001_.paramSet), (App)ResourceLocation.CODEC.optionalFieldOf("random_sequence").forGetter(p_297998_ -> Optional.ofNullable(p_297998_.randomSequence)), (App)MiscHelper.spawnPoolsCodec(SpawnPool::setName).optionalFieldOf("pools", List.of()).forGetter(p_298002_ -> p_298002_.pools), (App)ConditionalOps.decodeListWithElementConditions(SpawnEntityFunctions.ROOT_CODEC).optionalFieldOf("functions", List.of()).forGetter(p_298000_ -> p_298000_.functions)).apply((Applicative)p_338123_, SpawnTable::new));
    public static final Codec<Holder<SpawnTable>> CODEC = RegistryFileCodec.create(ExtraRegistries.Keys.SPAWN_TABLES, DIRECT_CODEC);
    public static final Codec<Either<ResourceKey<SpawnTable>, SpawnTable>> GATHER_CODEC = Codec.either((Codec)ResourceKey.codec(ExtraRegistries.Keys.SPAWN_TABLES), DIRECT_CODEC);
    static final Logger LOGGER = LogUtils.getLogger();
    public static final SpawnTable EMPTY = new SpawnTable(LootContextParamSets.EMPTY, Optional.empty(), List.of(), List.of());
    final LootContextParamSet paramSet;
    final ResourceLocation randomSequence;
    private final List<SpawnPool> pools;
    final List<SpawnEntityFunction> functions;
    private final BiFunction<Entity, SpawnContext, Entity> compositeFunction;
    private boolean isFrozen = false;
    private ResourceLocation lootTableId;

    SpawnTable(LootContextParamSet pParamSet, Optional<ResourceLocation> pRandomSequence, List<SpawnPool> pPools, List<SpawnEntityFunction> pFunctions) {
        this.paramSet = pParamSet;
        this.randomSequence = pRandomSequence.orElse(null);
        this.pools = Lists.newArrayList(pPools);
        this.functions = pFunctions;
        this.compositeFunction = SpawnEntityFunctions.compose(pFunctions);
    }

    public void getRandomEntities(LootParams pParams, long pSeed, Consumer<Entity> pOutput) {
        this.getRandomEntities(new SpawnContext.Builder(pParams).withOptionalRandomSeed(pSeed).create(this.randomSequence)).forEach(pOutput);
    }

    public void getRandomEntities(LootParams pParams, Consumer<Entity> pOutput) {
        this.getRandomEntities(pParams).forEach(pOutput);
    }

    public void getRandomEntities(SpawnContext pContextData, Consumer<Entity> pOutput) {
        this.getRandomEntities(pContextData).forEach(entity -> {
            pContextData.getLevel().addFreshEntity(entity);
            pOutput.accept((Entity)entity);
        });
    }

    public ObjectArrayList<Entity> getRandomEntities(LootParams pParams, long pSeed) {
        return this.getRandomEntities(new SpawnContext.Builder(pParams).withOptionalRandomSeed(pSeed).create(this.randomSequence));
    }

    public ObjectArrayList<Entity> getRandomEntities(LootParams pParams) {
        return this.getRandomEntities(new SpawnContext.Builder(pParams).create(this.randomSequence));
    }

    private ObjectArrayList<Entity> getRandomEntities(SpawnContext pContext) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Consumer<Entity> consumer = SpawnEntityFunction.decorate(this.compositeFunction, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0), pContext);
        for (SpawnPool pool : this.pools) {
            pool.addRandomEntities(consumer, pContext);
        }
        return objectarraylist;
    }

    public void getRandomEntitiesRaw(SpawnContext context, Consumer<Entity> output) {
        Consumer<Entity> consumer = SpawnEntityFunction.decorate(this.compositeFunction, output, context);
        for (SpawnPool pool : this.pools) {
            pool.addRandomEntities(consumer, context);
        }
    }

    public LootContextParamSet getParamSet() {
        return this.paramSet;
    }

    public void validate(ValidationContext pValidator) {
        for (int i = 0; i < this.pools.size(); ++i) {
            this.pools.get(i).validate(pValidator.forChild(".pools[" + i + "]"));
        }
        for (int j = 0; j < this.functions.size(); ++j) {
            this.functions.get(j).validate(pValidator.forChild(".functions[" + j + "]"));
        }
    }

    public static Builder spawnTable() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
        this.pools.forEach(SpawnPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public void setId(ResourceLocation id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + String.valueOf(this.lootTableId) + "' to '" + String.valueOf(id) + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    public ResourceLocation getLootTableId() {
        return this.lootTableId;
    }

    @Nullable
    public SpawnPool getPool(String name) {
        return this.pools.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    @Nullable
    public SpawnPool removePool(String name) {
        this.checkFrozen();
        for (SpawnPool pool : this.pools) {
            if (!name.equals(pool.getName())) continue;
            this.pools.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(SpawnPool pool) {
        this.checkFrozen();
        if (this.pools.stream().anyMatch(e -> e == pool || e.getName() != null && e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.pools.add(pool);
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final List<SpawnPool> pools = Lists.newArrayList();
        private final List<SpawnEntityFunction> functions = Lists.newArrayList();
        private LootContextParamSet paramSet = DEFAULT_PARAM_SET;
        @javax.annotation.Nullable
        private ResourceLocation randomSequence = null;

        public Builder withPool(SpawnPool.Builder pLootPool) {
            this.pools.add(pLootPool.build());
            return this;
        }

        public Builder setParamSet(LootContextParamSet pParameterSet) {
            this.paramSet = pParameterSet;
            return this;
        }

        public Builder setRandomSequence(ResourceLocation pRandomSequence) {
            this.randomSequence = pRandomSequence;
            return this;
        }

        @Override
        public Builder apply(SpawnEntityFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public SpawnTable build() {
            return new SpawnTable(this.paramSet, Optional.ofNullable(this.randomSequence), this.pools, this.functions);
        }
    }
}

