/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RaiderPropertiesFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<RaiderPropertiesFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("canJoinRaid", (Object)false).forGetter(f -> f.canJoinRaid), (App)Codec.BOOL.optionalFieldOf("celebrating", (Object)false).forGetter(f -> f.celebrating)).and(RaiderPropertiesFunction.commonFields(i).t1()).apply((Applicative)i, RaiderPropertiesFunction::new));
    private final Boolean canJoinRaid;
    private final Boolean celebrating;

    protected RaiderPropertiesFunction(Boolean canJoinRaid, Boolean celebrating, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        this.canJoinRaid = canJoinRaid;
        this.celebrating = celebrating;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof Raider) {
            Raider raider = (Raider)pEntity;
            if (this.canJoinRaid != null) {
                raider.setCanJoinRaid(this.canJoinRaid.booleanValue());
            }
            if (this.celebrating != null) {
                raider.setCelebrating(this.celebrating.booleanValue());
            }
        } else {
            RaiderPropertiesFunction.logWrongType("Raider", pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType<?> getType() {
        return SpawnEntityFunctions.RAIDER_PROPERTIES.get();
    }
}

