/*
 * Decompiled with CFR 0.152.
 */
package net.queuelogmod.rendering;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_11285;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9974;
import net.queuelogmod.util.QueueLogModManager;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

public class CustomRenderPipeline
implements ClientModInitializer {
    private static CustomRenderPipeline instance;
    QueueLogModManager manager = QueueLogModManager.getInstance();
    private static final RenderPipeline FILLED_THROUGH_WALLS;
    private static final class_9799 allocator;
    private class_287 buffer;
    private static final Vector4f COLOR_MODULATOR;
    private class_11285 vertexBuffer;

    public void onInitializeClient() {
        instance = this;
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::extractAndDrawWaypoint);
    }

    private void extractAndDrawWaypoint(WorldRenderContext context) {
        if (!this.manager.isUpdateDisplayToggle() || this.manager.getUpdateMap().isEmpty()) {
            return;
        }
        this.renderWaypoint(context);
        this.drawFilledThroughWalls(class_310.method_1551(), FILLED_THROUGH_WALLS);
    }

    private void renderWaypoint(WorldRenderContext context) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        assert (matrices != null);
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        if (this.buffer == null) {
            this.buffer = new class_287(allocator, FILLED_THROUGH_WALLS.getVertexFormatMode(), FILLED_THROUGH_WALLS.getVertexFormat());
        }
        for (Map.Entry<class_2338, Integer> entry : QueueLogModManager.getInstance().getUpdateMap().entrySet()) {
            class_2338 pos = entry.getKey();
            if (this.manager.isToggleHighlight() && this.manager.getGhostBlockSelected() != null && this.manager.getGhostBlockSelected().equals((Object)pos)) {
                class_9974.method_62294((class_4587)matrices, (class_4588)this.buffer, (float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260(), (float)(pos.method_10263() + 1), (float)(pos.method_10264() + 1), (float)(pos.method_10260() + 1), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2f);
                continue;
            }
            class_9974.method_62294((class_4587)matrices, (class_4588)this.buffer, (float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260(), (float)(pos.method_10263() + 1), (float)(pos.method_10264() + 1), (float)(pos.method_10260() + 1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        }
        matrices.method_22909();
    }

    private void drawFilledThroughWalls(class_310 client, RenderPipeline pipeline) {
        class_9801 builtBuffer = this.buffer.method_60800();
        class_9801.class_4574 drawParameters = builtBuffer.method_60822();
        VertexFormat format = drawParameters.comp_749();
        GpuBuffer vertices = this.upload(drawParameters, format, builtBuffer);
        CustomRenderPipeline.draw(client, pipeline, builtBuffer, drawParameters, vertices, format);
        this.vertexBuffer.method_71121();
        this.buffer = null;
    }

    private GpuBuffer upload(class_9801.class_4574 drawParameters, VertexFormat format, class_9801 builtBuffer) {
        int vertexBufferSize = drawParameters.comp_750() * format.getVertexSize();
        if (this.vertexBuffer == null || this.vertexBuffer.method_71312() < vertexBufferSize) {
            this.vertexBuffer = new class_11285(() -> "queuelogmod updatelog render pipeline", 34, vertexBufferSize);
        }
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(this.vertexBuffer.method_71119().slice(0, builtBuffer.method_60818().remaining()), false, true);){
            MemoryUtil.memCopy((ByteBuffer)builtBuffer.method_60818(), (ByteBuffer)mappedView.data());
        }
        return this.vertexBuffer.method_71119();
    }

    private static void draw(class_310 client, RenderPipeline pipeline, class_9801 builtBuffer, class_9801.class_4574 drawParameters, GpuBuffer vertices, VertexFormat format) {
        VertexFormat.class_5595 indexType;
        GpuBuffer indices;
        if (pipeline.getVertexFormatMode() == VertexFormat.class_5596.field_27382) {
            builtBuffer.method_60819(allocator, RenderSystem.getProjectionType().method_65045());
            indices = pipeline.getVertexFormat().uploadImmediateIndexBuffer(builtBuffer.method_60821());
            indexType = builtBuffer.method_60822().comp_753();
        } else {
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
            indices = shapeIndexBuffer.method_68274(drawParameters.comp_751());
            indexType = shapeIndexBuffer.method_31924();
        }
        GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)COLOR_MODULATOR, (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), 1.0f);
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "queuelogmod updatelog render pipeline rendering", client.method_1522().method_71639(), OptionalInt.empty(), client.method_1522().method_71640(), OptionalDouble.empty());){
            renderPass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", dynamicTransforms);
            renderPass.setVertexBuffer(0, vertices);
            renderPass.setIndexBuffer(indices, indexType);
            renderPass.drawIndexed(0 / format.getVertexSize(), 0, drawParameters.comp_751(), 1);
        }
        builtBuffer.close();
    }

    public void close() {
        allocator.close();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    public static CustomRenderPipeline getInstance() {
        return instance;
    }

    static {
        FILLED_THROUGH_WALLS = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(class_2960.method_60655((String)"queuelogmod", (String)"pipeline/debug_filled_box_through_walls")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
        allocator = new class_9799(786432);
        COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

