/*
 * Decompiled with CFR 0.152.
 */
package net.queuelogmod.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class QueueLogModManager {
    private static final QueueLogModManager INSTANCE = new QueueLogModManager();
    private final List<Log> updateLog = new ArrayList<Log>();
    private final Map<class_2338, Integer> updateMap = new ConcurrentHashMap<class_2338, Integer>();
    private class_2338 ghostBlockSelected = null;
    private boolean toggleHighlight = true;
    private boolean updateDisplayToggle = false;
    private boolean updateMonitorToggle = false;

    private QueueLogModManager() {
    }

    public static QueueLogModManager getInstance() {
        return INSTANCE;
    }

    public void addLog(class_2338 pos, class_2248 source) {
        this.updateLog.add(new Log(pos, source));
    }

    public void addKey(class_2338 pos) {
        this.updateMap.compute(pos, (k, v) -> v == null ? 1 : v + 1);
    }

    public void toggleUpdateDisplay() {
        this.updateDisplayToggle = !this.updateDisplayToggle;
    }

    public void toggleUpdateMonitor() {
        this.updateMonitorToggle = !this.updateMonitorToggle;
    }

    public void clearLogs() {
        this.updateLog.clear();
        this.updateMap.clear();
    }

    public int logCount() {
        return this.updateLog.size();
    }

    public String logCountPerCategory() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Log log : this.updateLog) {
            String baseNameStr = log.source().toString();
            int firstOperatorIndex = baseNameStr.indexOf(":");
            int secondOperatorIndex = -1;
            if (firstOperatorIndex != -1) {
                secondOperatorIndex = baseNameStr.indexOf("}", firstOperatorIndex + 1);
            }
            if (secondOperatorIndex != -1) {
                baseNameStr = baseNameStr.substring(firstOperatorIndex + 1, secondOperatorIndex);
            }
            map.compute(baseNameStr, (k, v) -> v == null ? 1 : v + 1);
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equals("air")) {
                result.append((String)entry.getKey()).append("(Block placement) : ").append(entry.getValue()).append("\n");
                continue;
            }
            result.append((String)entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
        }
        return result.toString();
    }

    public Map<class_2338, Integer> getUpdateMap() {
        return this.updateMap;
    }

    public void setGhostBlockSelected(class_2338 ghostBlockSelected) {
        this.ghostBlockSelected = ghostBlockSelected;
    }

    public class_2338 getGhostBlockSelected() {
        return this.ghostBlockSelected;
    }

    public void setToggleHighlight(boolean toggleHighlight) {
        this.toggleHighlight = toggleHighlight;
    }

    public boolean isToggleHighlight() {
        return this.toggleHighlight;
    }

    public boolean isUpdateDisplayToggle() {
        return this.updateDisplayToggle;
    }

    public boolean isUpdateMonitorToggle() {
        return this.updateMonitorToggle;
    }

    private record Log(class_2338 pos, class_2248 source) {
    }
}

