/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class PearlTracker {
    private static class_1684 trackedPearl = null;
    private static long throwTime = 0L;
    private static double predictedFlightTime = 0.0;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                if (trackedPearl == null) {
                    for (class_1297 entity : client.field_1687.method_18112()) {
                        class_1684 pearl;
                        if (!(entity instanceof class_1684) || (pearl = (class_1684)entity).method_24921() != client.field_1724) continue;
                        trackedPearl = pearl;
                        throwTime = System.currentTimeMillis();
                        predictedFlightTime = PearlTracker.simulatePearlFlight(pearl, client);
                        break;
                    }
                } else if (!trackedPearl.method_5805()) {
                    trackedPearl = null;
                    throwTime = 0L;
                    predictedFlightTime = 0.0;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            if (trackedPearl != null && throwTime != 0L && predictedFlightTime > 0.0) {
                double elapsed = (double)(System.currentTimeMillis() - throwTime) / 1000.0;
                double remaining = Math.max(0.0, predictedFlightTime - elapsed);
                String text = String.format("Pearl lands in: %.2f s", remaining);
                drawContext.method_51433(class_310.method_1551().field_1772, text, 10, 10, 0xFFFFFF, true);
            }
        });
    }

    private static double simulatePearlFlight(class_1684 pearl, class_310 client) {
        class_243 pos = pearl.method_19538();
        class_243 vel = pearl.method_18798();
        double gravity = 0.03;
        double drag = 0.99;
        int maxTicks = 200;
        double tickTime = 0.05;
        for (int tick = 0; tick < maxTicks; ++tick) {
            pos = pos.method_1019(vel);
            vel = vel.method_18805(drag, drag, drag);
            vel = vel.method_1023(0.0, gravity, 0.0);
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            class_2680 state = client.field_1687.method_8320(blockPos);
            if (!state.method_26215() && !state.method_26220((class_1922)client.field_1687, blockPos).method_1110()) {
                return (double)tick * tickTime;
            }
            if (!(pos.field_1351 < (double)client.field_1687.method_31607())) continue;
            return (double)tick * tickTime;
        }
        return (double)maxTicks * tickTime;
    }
}

