/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PearlConfig {
    public boolean showTimer = true;
    public int timerPosX = 10;
    public int timerPosY = 10;
    public float textScale = 1.0f;
    public int textColor = 0xFFFFFF;
    public int timerBgColor = Integer.MIN_VALUE;
    public boolean showTimerBg = false;
    public boolean showTimerShadow = true;
    public boolean showTimerOutline = false;
    public boolean onlySurvival = false;
    public boolean onlyF5 = false;
    public boolean onlySneaking = false;
    public boolean onlySprinting = false;
    public boolean onlyHoldingPearl = false;
    public boolean playLandingSound = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/pearlecho.json");
    public static PearlConfig INSTANCE = new PearlConfig();

    public static void load() {
        try {
            if (CONFIG_FILE.exists()) {
                INSTANCE = (PearlConfig)GSON.fromJson((Reader)new FileReader(CONFIG_FILE), PearlConfig.class);
                System.out.println("Loaded config from: " + CONFIG_FILE.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
            System.out.println("Saved config to: " + CONFIG_FILE.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

