/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PearlConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;

@Environment(value=EnvType.CLIENT)
public class PearlTracker {
    private static class_1684 trackedPearl = null;
    private static long throwTime = 0L;
    private static double predictedFlightTime = 0.0;
    private static boolean playedLandSound = false;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                if (trackedPearl == null) {
                    for (class_1297 entity : client.field_1687.method_18112()) {
                        class_1684 pearl;
                        if (!(entity instanceof class_1684) || (pearl = (class_1684)entity).method_24921() != client.field_1724) continue;
                        trackedPearl = pearl;
                        throwTime = System.currentTimeMillis();
                        predictedFlightTime = PearlTracker.simulatePearlFlight(pearl, client);
                        playedLandSound = false;
                        break;
                    }
                } else if (!trackedPearl.method_5805()) {
                    if (!playedLandSound && client.field_1724 != null && PearlConfig.INSTANCE.playLandingSound) {
                        client.field_1724.method_5783(class_3417.field_14627, 1.0f, 1.0f);
                        playedLandSound = true;
                    }
                    trackedPearl = null;
                    throwTime = 0L;
                    predictedFlightTime = 0.0;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            class_310 client = class_310.method_1551();
            if (!PearlTracker.shouldShowHUD(client)) {
                return;
            }
            if (trackedPearl != null && throwTime != 0L && predictedFlightTime > 0.0) {
                int height;
                int width;
                double elapsed = (double)(System.currentTimeMillis() - throwTime) / 1000.0;
                double remaining = Math.max(0.0, predictedFlightTime - elapsed);
                String text = String.format("Pearl lands in: %.2f s", remaining);
                drawContext.method_51448().method_22903();
                drawContext.method_51448().method_22905(PearlConfig.INSTANCE.textScale, PearlConfig.INSTANCE.textScale, 1.0f);
                int x = (int)((float)PearlConfig.INSTANCE.timerPosX / PearlConfig.INSTANCE.textScale);
                int y = (int)((float)PearlConfig.INSTANCE.timerPosY / PearlConfig.INSTANCE.textScale);
                if (PearlConfig.INSTANCE.showTimerBg) {
                    width = client.field_1772.method_1727(text) + 8;
                    height = 16;
                    drawContext.method_25294(x - 4, y - 2, x + width, y + height, PearlConfig.INSTANCE.timerBgColor);
                }
                if (PearlConfig.INSTANCE.showTimerOutline) {
                    width = client.field_1772.method_1727(text) + 8;
                    height = 16;
                    drawContext.method_49601(x - 4, y - 2, width, height, -16777216);
                }
                drawContext.method_51433(client.field_1772, text, x, y, PearlConfig.INSTANCE.textColor, PearlConfig.INSTANCE.showTimerShadow);
                drawContext.method_51448().method_22909();
            }
        });
    }

    private static boolean shouldShowHUD(class_310 client) {
        if (!PearlConfig.INSTANCE.showTimer) {
            return false;
        }
        if (PearlConfig.INSTANCE.onlySurvival && !PearlTracker.isSurvival(client)) {
            return false;
        }
        if (PearlConfig.INSTANCE.onlyF5 && client.field_1690.method_31044().method_31034()) {
            return false;
        }
        if (PearlConfig.INSTANCE.onlySneaking && (client.field_1724 == null || !client.field_1724.method_5715())) {
            return false;
        }
        if (PearlConfig.INSTANCE.onlySprinting && (client.field_1724 == null || !client.field_1724.method_5624())) {
            return false;
        }
        return !PearlConfig.INSTANCE.onlyHoldingPearl || client.field_1724 != null && client.field_1724.method_6047().method_7909() == class_1802.field_8634;
    }

    private static boolean isSurvival(class_310 client) {
        return client.field_1724 != null && !client.field_1724.method_7325() && !client.field_1724.method_31549().field_7477;
    }

    private static double simulatePearlFlight(class_1684 pearl, class_310 client) {
        class_243 pos = pearl.method_19538();
        class_243 vel = pearl.method_18798();
        double gravity = 0.03;
        double drag = 0.99;
        int maxTicks = 200;
        double tickTime = 0.05;
        for (int tick = 0; tick < maxTicks; ++tick) {
            pos = pos.method_1019(vel);
            vel = vel.method_18805(drag, drag, drag);
            vel = vel.method_1023(0.0, gravity, 0.0);
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            class_2680 state = client.field_1687.method_8320(blockPos);
            if (!state.method_26215() && !state.method_26220((class_1922)client.field_1687, blockPos).method_1110()) {
                return (double)tick * tickTime;
            }
            if (!(pos.field_1351 < (double)client.field_1687.method_31607())) continue;
            return (double)tick * tickTime;
        }
        return (double)maxTicks * tickTime;
    }
}

