/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import de.cech12.solarcooker.client.SolarCookerRenderState;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SolarCookerBlockEntityRenderer
implements class_827<SolarCookerBlockEntity, SolarCookerRenderState> {
    private static final class_4730 MATERIAL_BASE = class_4722.field_56359.method_67273(Constants.id("solar_cooker"));
    private static final class_4730 MATERIAL_REFLECTOR = class_4722.field_56359.method_67273(Constants.id("solar_cooker_reflector"));
    private static final class_5607 innerCube = SolarCookerBlockEntityRenderer.createInnerLayerDefinition();
    private static final class_5607 reflectorLeftCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(true);
    private static final class_5607 reflectorRightCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(false);
    private final class_11701 materials;
    private final class_10442 itemModelResolver;
    private final class_630 lid;
    private final class_630 bottom;
    private final class_630 inner;
    private final class_630 lock;
    private final class_630 reflectorLeft;
    private final class_630 reflectorRight;

    private static class_5607 createInnerLayerDefinition() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        partdefinition.method_32117("inner", class_5606.method_32108().method_32101(0, 43).method_32097(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    private static class_5607 createReflectorLayerDefinition(boolean left) {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        float offset = left ? 0.0f : 13.998f;
        float rotation = left ? 0.0f : (float)Math.PI;
        partdefinition.method_32117("reflector", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 6.999f, 1.0f, 13.998f), class_5603.method_32091((float)(1.001f + offset), (float)10.001f, (float)(1.001f + offset), (float)0.0f, (float)rotation, (float)0.0f));
        return class_5607.method_32110((class_5609)meshdefinition, (int)42, (int)15);
    }

    public SolarCookerBlockEntityRenderer(class_5614.class_5615 rendererProvider) {
        this.materials = rendererProvider.comp_4541();
        this.itemModelResolver = rendererProvider.comp_4536();
        class_630 modelpart = rendererProvider.method_32140(class_5602.field_27689);
        this.bottom = modelpart.method_32086("bottom");
        this.lid = modelpart.method_32086("lid");
        this.lock = modelpart.method_32086("lock");
        this.inner = innerCube.method_32109().method_32086("inner");
        this.reflectorLeft = reflectorLeftCube.method_32109().method_32086("reflector");
        this.reflectorRight = reflectorRightCube.method_32109().method_32086("reflector");
    }

    public SolarCookerRenderState createRenderState() {
        return new SolarCookerRenderState();
    }

    public void extractRenderState(@NotNull SolarCookerBlockEntity blockEntity, @NotNull SolarCookerRenderState blockEntityRenderState, float partialTicks, @NotNull class_243 vec, @Nullable class_11683.class_11792 overlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)blockEntityRenderState, partialTicks, vec, overlay);
        class_2680 state = blockEntity.method_10997() != null ? blockEntity.method_11010() : (class_2680)Constants.SOLAR_COOKER_BLOCK.get().method_9564().method_11657(AbstractSolarCookerBlock.FACING, (Comparable)class_2350.field_11035);
        blockEntityRenderState.angle = ((class_2350)state.method_11654(AbstractSolarCookerBlock.FACING)).method_10144();
        blockEntityRenderState.open = blockEntity.method_11274(partialTicks);
        blockEntityRenderState.hasLeftReflector = blockEntity.hasLeftReflector();
        blockEntityRenderState.hasRightReflector = blockEntity.hasRightReflector();
        class_10444 itemStackRenderState = new class_10444();
        this.itemModelResolver.method_65598(itemStackRenderState, blockEntity.method_5438(0), class_811.field_4319, blockEntity.method_10997(), null, 0);
        blockEntityRenderState.stack = itemStackRenderState;
    }

    public void submit(@NotNull SolarCookerRenderState blockEntityRenderState, @NotNull class_4587 matrixStackIn, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        matrixStackIn.method_22903();
        matrixStackIn.method_22904(0.5, 0.5, 0.5);
        matrixStackIn.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-blockEntityRenderState.angle));
        matrixStackIn.method_22904(-0.5, -0.5, -0.5);
        float lidAngle = blockEntityRenderState.open;
        this.renderModels(matrixStackIn, submitNodeCollector, lidAngle, blockEntityRenderState.field_62676);
        if (lidAngle > 0.0f) {
            class_10444 itemStackRenderState;
            if (blockEntityRenderState.hasLeftReflector || blockEntityRenderState.hasRightReflector) {
                this.renderReflectors(matrixStackIn, submitNodeCollector, blockEntityRenderState.hasLeftReflector, blockEntityRenderState.hasRightReflector, lidAngle, blockEntityRenderState.field_62676);
            }
            if (!(itemStackRenderState = blockEntityRenderState.stack).method_65606()) {
                matrixStackIn.method_22903();
                matrixStackIn.method_22904(0.5, 0.55, 0.5);
                matrixStackIn.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
                itemStackRenderState.method_65604(matrixStackIn, submitNodeCollector, blockEntityRenderState.field_62676, class_4608.field_21444, 0);
                matrixStackIn.method_22909();
            }
        }
        matrixStackIn.method_22909();
    }

    private void renderModels(class_4587 matrixStackIn, class_11659 submitNodeCollector, float lidAngle, int combinedLightIn) {
        this.lock.field_3654 = this.lid.field_3654 = -(lidAngle * 1.5707964f);
        class_1921 renderType = MATERIAL_BASE.method_24146(class_1921::method_23580);
        class_1058 sprite = this.materials.method_73030(MATERIAL_BASE);
        submitNodeCollector.method_73491(this.lid, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
        submitNodeCollector.method_73491(this.lock, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
        submitNodeCollector.method_73491(this.bottom, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
        submitNodeCollector.method_73491(this.inner, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
    }

    private void renderReflectors(class_4587 matrixStackIn, class_11659 submitNodeCollector, boolean hasLeftReflector, boolean hasRightReflector, float lidAngle, int combinedLightIn) {
        if (hasLeftReflector || hasRightReflector) {
            class_1921 renderType = MATERIAL_REFLECTOR.method_24146(class_1921::method_23580);
            class_1058 sprite = this.materials.method_73030(MATERIAL_REFLECTOR);
            float angle = lidAngle * 1.7453294f;
            if (hasLeftReflector) {
                this.reflectorLeft.field_3674 = angle;
                submitNodeCollector.method_73491(this.reflectorLeft, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
            }
            if (hasRightReflector) {
                this.reflectorRight.field_3674 = -angle;
                submitNodeCollector.method_73491(this.reflectorRight, matrixStackIn, renderType, combinedLightIn, class_4608.field_21444, sprite);
            }
        }
    }
}

