/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.rei;

import com.google.common.collect.Lists;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.rei.SolarCookingReiDisplay;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SolarCookingReiDisplayCategory
implements DisplayCategory<SolarCookingReiDisplay> {
    public static final CategoryIdentifier<SolarCookingReiDisplay> ID = CategoryIdentifier.of((String)"solarcooker", (String)"solarcooking");

    public CategoryIdentifier<? extends SolarCookingReiDisplay> getCategoryIdentifier() {
        return ID;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.solarcooker.solar_cooker");
    }

    public Renderer getIcon() {
        return EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)Constants.SOLAR_COOKER_ITEM.get()));
    }

    public int getDisplayHeight() {
        return 49;
    }

    public DisplayRenderer getDisplayRenderer(SolarCookingReiDisplay display) {
        return SimpleDisplayRenderer.from(Collections.singletonList((EntryIngredient)display.getInputEntries().get(0)), (List)display.getOutputEntries());
    }

    public List<Widget> setupDisplay(SolarCookingReiDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double cookingTime = display.getCookTime();
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (Component)Component.translatable((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.getXp()), df.format(cookingTime / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(cookingTime));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }
}

