/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.jei;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.crafting.SolarCookingRecipe;
import de.cech12.solarcooker.jei.SolarCookingCategory;
import de.cech12.solarcooker.platform.Services;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@JeiPlugin
public class SolarCookerJEIPlugin
implements IModPlugin {
    private static SolarCookingCategory solarCookingCategory;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return Constants.id("plugin_solarcooker");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        solarCookingCategory = new SolarCookingCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{solarCookingCategory});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            RecipeMap recipeMap = server.getRecipeManager().recipeMap();
            registration.addRecipes(solarCookingCategory.getRecipeType(), recipeMap.byType(Constants.SOLAR_COOKING_RECIPE_TYPE.get()).stream().toList());
            if (Services.CONFIG.areVanillaRecipesEnabled()) {
                registration.addRecipes(solarCookingCategory.getRecipeType(), recipeMap.byType(Services.CONFIG.getRecipeType()).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)SolarCookingRecipe.convert((AbstractCookingRecipe)recipe.value(), (RegistryAccess)server.registryAccess()))).collect(Collectors.toList()));
            }
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(solarCookingCategory.getRecipeType(), new ItemStack[]{new ItemStack((ItemLike)Constants.SOLAR_COOKER_BLOCK.get())});
    }
}

