/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.platform;

import de.cech12.solarcooker.platform.services.IConfigHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    public static final ModConfigSpec.BooleanValue VANILLA_RECIPES_ENABLED;
    public static final ModConfigSpec.ConfigValue<String> VANILLA_RECIPE_TYPE;
    public static final ModConfigSpec.DoubleValue COOK_TIME_FACTOR;
    public static final ModConfigSpec.DoubleValue MAX_REFLECTOR_TIME_FACTOR;
    public static final ModConfigSpec.ConfigValue<String> RECIPE_BLOCKED_LIST;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public boolean areVanillaRecipesEnabled() {
        try {
            return (Boolean)VANILLA_RECIPES_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        return switch ((String)VANILLA_RECIPE_TYPE.get()) {
            case "smoking" -> RecipeType.SMOKING;
            case "smelting" -> RecipeType.SMELTING;
            case "campfire_cooking" -> RecipeType.CAMPFIRE_COOKING;
            case "blasting" -> RecipeType.BLASTING;
            default -> VANILLA_RECIPE_TYPE_DEFAULT;
        };
    }

    @Override
    public double getCookTimeFactor() {
        try {
            return (Double)COOK_TIME_FACTOR.get();
        }
        catch (IllegalStateException ex) {
            return 4.0;
        }
    }

    @Override
    public double getMaxReflectorTimeFactor() {
        try {
            return (Double)MAX_REFLECTOR_TIME_FACTOR.get();
        }
        catch (IllegalStateException ex) {
            return 0.5;
        }
    }

    @Override
    public String getRecipeBlockedList() {
        try {
            return (String)RECIPE_BLOCKED_LIST.get();
        }
        catch (IllegalStateException ex) {
            return "";
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Options that affect the added Solar Cooker.").push("Solar Cooker Settings");
        VANILLA_RECIPES_ENABLED = builder.comment("If enabled, the vanilla blasting, smelting, or smoking recipes are used by the solar cooker.").define("vanillaRecipesEnabled", true);
        VANILLA_RECIPE_TYPE = builder.comment("Defines which vanilla recipes the solar cooker can use. Possible values: \"smelting\" (default),\"smoking\", \"blasting\", \"campfire_cooking\"").define("vanillaRecipeType", (Object)BuiltInRegistries.RECIPE_TYPE.getKey((Object)VANILLA_RECIPE_TYPE_DEFAULT).getPath());
        COOK_TIME_FACTOR = builder.comment("Cook time factor of the solar cooker in relation to corresponding vanilla furnace. (i. e. 0.5 - half the time, 1.0 same time, 2.0 twice the time)").defineInRange("cookTimeFactor", 4.0, 0.0, 100.0);
        MAX_REFLECTOR_TIME_FACTOR = builder.comment("Speed factor when all reflector slots are filled in the solar cooker. (i. e. 0.5 - half the time, 1.0 same time)").defineInRange("maxReflectorSpeedFactor", 0.5, 0.0, 1.0);
        RECIPE_BLOCKED_LIST = builder.comment("A comma separated list of all vanilla recipes that should not be used by the solar cooker. Example: \"baked_potato,baked_potato_from_smoking,othermod:other_baked_food\"").define("recipeBlockedList", (Object)"");
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

