/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.inventory;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.inventory.SolarCookerReflectorSlot;
import de.cech12.solarcooker.inventory.SolarCookerResultSlot;
import de.cech12.solarcooker.platform.Services;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class SolarCookerContainer
extends AbstractContainerMenu {
    private final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final Container cooker;
    private final ContainerData data;
    protected final Level level;

    public SolarCookerContainer(RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, Inventory playerInventoryIn, Container cooker, ContainerData data) {
        super(Constants.SOLAR_COOKER_MENU_TYPE.get(), id);
        this.specificRecipeType = specificRecipeTypeIn;
        AbstractContainerMenu.checkContainerSize((Container)cooker, (int)4);
        this.cooker = cooker;
        this.data = data;
        cooker.startOpen(playerInventoryIn.player);
        this.level = playerInventoryIn.player.level();
        this.addSlot(new Slot(cooker, 0, 56, 17));
        this.addSlot((Slot)new SolarCookerResultSlot(playerInventoryIn.player, cooker, 1, 116, 35));
        this.addSlot(new SolarCookerReflectorSlot(cooker, 2, 153, 7));
        this.addSlot(new SolarCookerReflectorSlot(cooker, 3, 153, 25));
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventoryIn, j1 + playerInvRow * 9 + 9, 8 + j1 * 18, 84 + playerInvRow * 18));
            }
        }
        for (int playerHotbarSlot = 0; playerHotbarSlot < 9; ++playerHotbarSlot) {
            this.addSlot(new Slot((Container)playerInventoryIn, playerHotbarSlot, 8 + playerHotbarSlot * 18, 142));
        }
        this.addDataSlots(this.data);
    }

    public SolarCookerContainer(RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, Inventory playerInventoryIn) {
        this(specificRecipeTypeIn, id, playerInventoryIn, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(3));
    }

    public boolean stillValid(@Nonnull Player playerIn) {
        return this.cooker.stillValid(playerIn);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 0 ? (this.hasRecipe(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void setItem(int slotID, int stateId, @Nonnull ItemStack stack) {
        super.setItem(slotID, stateId, stack);
    }

    protected boolean hasRecipe(ItemStack stack) {
        if (this.level != null && this.level.getServer() != null) {
            SingleRecipeInput recipeInput = new SingleRecipeInput(stack);
            if (this.level.getServer().getRecipeManager().getRecipeFor(this.specificRecipeType, (RecipeInput)recipeInput, this.level).isPresent()) {
                return true;
            }
            if (Services.CONFIG.areVanillaRecipesEnabled()) {
                return this.level.getServer().getRecipeManager().getRecipes().stream().filter(recipe -> recipe.value().getType() == Services.CONFIG.getRecipeType()).filter(recipe -> recipe.value() instanceof AbstractCookingRecipe).map(recipe -> recipe).filter(recipe -> ((AbstractCookingRecipe)recipe.value()).matches(recipeInput, this.level)).anyMatch(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location()));
            }
        }
        return false;
    }

    public void removed(@Nonnull Player playerIn) {
        super.removed(playerIn);
        this.cooker.stopOpen(playerIn);
    }

    public int getCookProgressionScaled() {
        int i = this.data.get(1);
        int j = this.data.get(2);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isBurning() {
        return this.data.get(1) > 0;
    }

    public boolean isSunlit() {
        return this.data.get(0) > 0;
    }

    public Container getContainer() {
        return this.cooker;
    }
}

