/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.solarcooker.crafting.SolarCookingRecipe;
import de.cech12.solarcooker.platform.Services;
import de.cech12.solarcooker.rei.SolarCookingReiDisplayCategory;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SolarCookingReiDisplay
extends BasicDisplay {
    public static DisplaySerializer<SolarCookingReiDisplay> SERIALIZER = SolarCookingReiDisplay.serializer();
    private final float xp;
    private final double cookTime;

    public <T extends AbstractCookingRecipe> SolarCookingReiDisplay(RecipeHolder<T> recipe) {
        this(List.of(EntryIngredients.ofIngredient((Ingredient)((AbstractCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of((ItemStack)((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(new ItemStack((ItemLike)((Holder)((AbstractCookingRecipe)recipe.value()).input().items().findFirst().get()).value())), null))), Optional.of(recipe.id().location()), ((AbstractCookingRecipe)recipe.value()).experience(), recipe.value() instanceof SolarCookingRecipe ? (double)((AbstractCookingRecipe)recipe.value()).cookingTime() : (double)((AbstractCookingRecipe)recipe.value()).cookingTime() * Services.CONFIG.getCookTimeFactor());
    }

    public SolarCookingReiDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> id, CompoundTag tag) {
        this(input, output, id, tag.getFloat("xp"), tag.getDouble("cookTime"));
    }

    public SolarCookingReiDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> id, float xp, double cookTime) {
        super(input, output, id);
        this.xp = xp;
        this.cookTime = cookTime;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SolarCookingReiDisplayCategory.ID;
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public double getCookTime() {
        return this.cookTime;
    }

    public float getXp() {
        return this.xp;
    }

    private static DisplaySerializer<SolarCookingReiDisplay> serializer() {
        return DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)Codec.FLOAT.fieldOf("xp").forGetter(display -> Float.valueOf(display.xp)), (App)Codec.DOUBLE.fieldOf("cookTime").forGetter(display -> display.cookTime)).apply((Applicative)instance, SolarCookingReiDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), BasicDisplay::getDisplayLocation, (StreamCodec)ByteBufCodecs.FLOAT, display -> Float.valueOf(display.xp), (StreamCodec)ByteBufCodecs.DOUBLE, display -> display.cookTime, SolarCookingReiDisplay::new));
    }
}

