/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.platform.services;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;

public interface IConfigHelper {
    public static final boolean VANILLA_RECIPES_ENABLED_DEFAULT = true;
    public static final String VANILLA_RECIPES_ENABLED_DESCRIPTION = "If enabled, the vanilla blasting, smelting, or smoking recipes are used by the solar cooker.";
    public static final RecipeType<? extends AbstractCookingRecipe> VANILLA_RECIPE_TYPE_DEFAULT = RecipeType.SMELTING;
    public static final String VANILLA_RECIPE_TYPE_DESCRIPTION = "Defines which vanilla recipes the solar cooker can use. Possible values: \"smelting\" (default),\"smoking\", \"blasting\", \"campfire_cooking\"";
    public static final double COOK_TIME_FACTOR_DEFAULT = 4.0;
    public static final String COOK_TIME_FACTOR_DESCRIPTION = "Cook time factor of the solar cooker in relation to corresponding vanilla furnace. (i. e. 0.5 - half the time, 1.0 same time, 2.0 twice the time)";
    public static final double COOK_TIME_FACTOR_MIN = 0.0;
    public static final double COOK_TIME_FACTOR_MAX = 100.0;
    public static final double MAX_REFLECTOR_TIME_FACTOR_DEFAULT = 0.5;
    public static final String MAX_REFLECTOR_TIME_FACTOR_DESCRIPTION = "Speed factor when all reflector slots are filled in the solar cooker. (i. e. 0.5 - half the time, 1.0 same time)";
    public static final double MAX_REFLECTOR_TIME_FACTOR_MIN = 0.0;
    public static final double MAX_REFLECTOR_TIME_FACTOR_MAX = 1.0;
    public static final String RECIPE_BLOCKED_LIST_DEFAULT = "";
    public static final String RECIPE_BLOCKED_LIST_DESCRIPTION = "A comma separated list of all vanilla recipes that should not be used by the solar cooker. Example: \"baked_potato,baked_potato_from_smoking,othermod:other_baked_food\"";

    public void init();

    public boolean areVanillaRecipesEnabled();

    public RecipeType<? extends AbstractCookingRecipe> getRecipeType();

    public double getCookTimeFactor();

    public double getMaxReflectorTimeFactor();

    public String getRecipeBlockedList();

    default public boolean isRecipeAllowed(ResourceLocation id) {
        String configValue = this.getRecipeBlockedList().trim();
        if (!configValue.isEmpty()) {
            String[] ids = configValue.split(",");
            if (ids.length < 1) {
                return !ResourceLocation.parse((String)configValue).equals((Object)id);
            }
            for (String recipeId : ids) {
                if (!ResourceLocation.parse((String)recipeId.trim()).equals((Object)id)) continue;
                return false;
            }
        }
        return true;
    }
}

