/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.mixin;

import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import java.util.Objects;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IngredientFluidStack.class})
public abstract class IngredientFluidStackMixin {
    @Shadow
    @Final
    private SizedFluidIngredient fluidIngredient;

    @Inject(method={"getItems"}, at={@At(value="HEAD")}, cancellable=true)
    public void getItems(CallbackInfoReturnable<Stream<ItemStack>> cir) {
        cir.setReturnValue(RecipeHelpers.stream((SizedFluidIngredient)this.fluidIngredient).flatMap(fluid -> Helpers.allItems((TagKey)TFCTags.Items.FLUID_ITEM_INGREDIENT_EMPTY_CONTAINERS).map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null) {
                fluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
                FluidStack content = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (content.getFluid() == fluid && content.getAmount() >= this.fluidIngredient.amount()) {
                    return fluidHandler.getContainer();
                }
            }
            return null;
        })).filter(Objects::nonNull));
    }
}

