/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.world.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.nmagpie.tfc_ie_addon.common.blocks.BuddingQuartzBlock;
import com.nmagpie.tfc_ie_addon.world.feature.GeodeConfig;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;

public class GeodeFeature
extends Feature<GeodeConfig> {
    public GeodeFeature(Codec<GeodeConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<GeodeConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        GeodeConfig config = (GeodeConfig)context.config();
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(level.getSeed()));
        NormalNoise normalnoise = NormalNoise.create((RandomSource)worldgenrandom, (int)-4, (double[])new double[]{1.0});
        boolean cracked = (double)random.nextFloat() < (double)0.95f;
        LinkedList list = Lists.newLinkedList();
        LinkedList crackBlocks = Lists.newLinkedList();
        UniformInt outerWall = UniformInt.of((int)4, (int)6);
        UniformInt pointOffset = UniformInt.of((int)1, (int)2);
        int distributionPoint = UniformInt.of((int)3, (int)4).sample(random);
        double relativeDistributionPoint = (double)distributionPoint / (double)outerWall.getMaxValue();
        double fillLimit = 1.0 / Math.sqrt(1.7);
        double innerLimit = 1.0 / Math.sqrt(2.2 + relativeDistributionPoint);
        double middleLimit = 1.0 / Math.sqrt(3.2 + relativeDistributionPoint);
        double outerLimit = 1.0 / Math.sqrt(4.2 + relativeDistributionPoint);
        double distWeight = 1.0 / Math.sqrt(2.0 + random.nextDouble() / 2.0 + (distributionPoint > 3 ? relativeDistributionPoint : 0.0));
        int invalid = 0;
        for (int i1 = 0; i1 < distributionPoint; ++i1) {
            int z;
            int y;
            int x = outerWall.sample(random);
            BlockPos offsetPos = origin.offset(x, y = outerWall.sample(random), z = outerWall.sample(random));
            BlockState found = level.getBlockState(offsetPos);
            if ((found.isAir() || Helpers.isBlock((BlockState)found, (TagKey)BlockTags.GEODE_INVALID_BLOCKS)) && ++invalid > 1) {
                return false;
            }
            list.add(Pair.of((Object)offsetPos, (Object)pointOffset.sample(random)));
        }
        if (cracked) {
            int type = random.nextInt(4);
            int dist = distributionPoint * 2 + 1;
            if (type == 0) {
                crackBlocks.add(origin.offset(dist, 7, 0));
                crackBlocks.add(origin.offset(dist, 5, 0));
                crackBlocks.add(origin.offset(dist, 1, 0));
            } else if (type == 1) {
                crackBlocks.add(origin.offset(0, 7, dist));
                crackBlocks.add(origin.offset(0, 5, dist));
                crackBlocks.add(origin.offset(0, 1, dist));
            } else if (type == 2) {
                crackBlocks.add(origin.offset(dist, 7, dist));
                crackBlocks.add(origin.offset(dist, 5, dist));
                crackBlocks.add(origin.offset(dist, 1, dist));
            } else {
                crackBlocks.add(origin.offset(0, 7, 0));
                crackBlocks.add(origin.offset(0, 5, 0));
                crackBlocks.add(origin.offset(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate predicate = GeodeFeature.isReplaceable((TagKey)BlockTags.FEATURES_CANNOT_REPLACE);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(-16, -16, -16), (BlockPos)origin.offset(16, 16, 16))) {
            double noise = normalnoise.getValue((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) * 0.05;
            double pointAt = 0.0;
            double crackWeight = 0.0;
            for (Pair pair : list) {
                pointAt += Mth.invSqrt((double)(pos.distSqr((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + noise;
            }
            for (BlockPos crackPos : crackBlocks) {
                crackWeight += Mth.invSqrt((double)(pos.distSqr((Vec3i)crackPos) + 2.0)) + noise;
            }
            if (pointAt < outerLimit) continue;
            if (cracked && crackWeight >= distWeight && pointAt < fillLimit) {
                this.safeSetBlock(level, pos, Blocks.AIR.defaultBlockState(), predicate);
                for (Direction d : Helpers.DIRECTIONS) {
                    BlockPos relativePos = pos.relative(d);
                    FluidState fluid = level.getFluidState(relativePos);
                    if (fluid.isEmpty()) continue;
                    level.scheduleTick(relativePos, fluid.getType(), 0);
                }
                continue;
            }
            if (pointAt >= fillLimit) {
                this.safeSetBlock(level, pos, config.filling().getRandomValue(random).orElse(Blocks.AIR.defaultBlockState()), predicate);
                continue;
            }
            if (pointAt >= innerLimit) {
                boolean flag1 = (double)random.nextFloat() < 0.083;
                this.safeSetBlock(level, pos, (BlockState)config.inner().getRandomValue(random).orElseThrow(), predicate);
                if (!flag1 || !((double)random.nextFloat() < 0.35)) continue;
                list2.add(pos.immutable());
                continue;
            }
            if (pointAt >= middleLimit) {
                this.safeSetBlock(level, pos, config.middle(), predicate);
                continue;
            }
            if (!(pointAt >= outerLimit)) continue;
            this.safeSetBlock(level, pos, config.outer(), predicate);
        }
        block5: for (BlockPos blockpos4 : list2) {
            BlockState blockstate1 = (BlockState)config.innerPlacements().getRandomValue(random).orElseThrow();
            for (Direction direction : Helpers.DIRECTIONS) {
                if (blockstate1.hasProperty((Property)BlockStateProperties.FACING)) {
                    blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
                }
                BlockPos blockpos5 = blockpos4.relative(direction);
                BlockState blockstate2 = level.getBlockState(blockpos5);
                if (blockstate1.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate2.getFluidState().isSource()));
                }
                if (!BuddingQuartzBlock.canClusterGrowAtState((BlockState)blockstate2)) continue;
                this.safeSetBlock(level, blockpos5, blockstate1, predicate);
                continue block5;
            }
        }
        return true;
    }
}

