/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import com.nmagpie.tfc_ie_addon.config.Config;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEvents::clientSetup);
        bus.addListener(ClientEvents::registerColorHandlerBlocks);
        bus.addListener(ClientEvents::registerColorHandlerItems);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.m_110463_();
        Stream.of(Blocks.SMALL_BAUXITE, Blocks.SMALL_GALENA, Blocks.SMALL_URANINITE, Blocks.BUDDING_QUARTZ, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_CLUSTER, Blocks.LARGE_QUARTZ_BUD, Blocks.MEDIUM_QUARTZ_BUD, Blocks.SMALL_QUARTZ_BUD).forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        Blocks.BAUXITE_ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        Blocks.GALENA_ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        Blocks.URANINITE_ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        ClientEvents.setupManual();
    }

    private static void setupManual() {
        ManualHelper.addConfigGetter(str -> switch (str) {
            case "crucibleExternalHeaterFEPerTick" -> (Integer)Config.SERVER.crucibleExternalHeaterFEPerTick.get();
            case "crucibleExternalHeaterTemperature" -> (Integer)Config.SERVER.crucibleExternalHeaterTemperature.get();
            default -> -1;
        });
    }

    public static void registerColorHandlerBlocks(RegisterColorHandlersEvent.Block event) {
        Blocks.METAL_CAULDRONS.forEach((metal, reg) -> event.register((state, level, pos, tintIndex) -> metal.getColor(), new Block[]{(Block)reg.get()}));
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            if (!Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).m_135827_().equals("tfc_ie_addon")) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{fluid.m_6859_()});
        }
    }
}

