/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.common;

import com.nmagpie.tfc_ie_addon.TFC_IE_Addon;
import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import com.nmagpie.tfc_ie_addon.common.items.Items;
import com.nmagpie.tfc_ie_addon.util.IEMetal;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tfc_ie_addon");
    public static final RegistryObject<CreativeModeTab> MAIN = CreativeTabs.register("main", () -> new ItemStack((ItemLike)Items.QUARTZ_SHARD.get()), CreativeTabs::fillTab);

    private static RegistryObject<CreativeModeTab> register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        return CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("tfc_ie_addon.creative_tab." + name))).m_257501_(displayItems).m_257652_());
    }

    private static void fillTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        CreativeTabs.accept(out, Items.WIRECUTTER_HEAD);
        CreativeTabs.accept(out, Items.HAMMER_HEAD);
        CreativeTabs.accept(out, Items.MOLD_SHEET);
        CreativeTabs.accept(out, Items.MOLD_BLOCK);
        CreativeTabs.accept(out, Items.DRILLHEAD_BLACK_STEEL);
        CreativeTabs.accept(out, Items.DRILLHEAD_BLUE_STEEL);
        CreativeTabs.accept(out, Items.DRILLHEAD_RED_STEEL);
        CreativeTabs.accept(out, Items.TREATED_WOOD_LUMBER);
        CreativeTabs.accept(out, Blocks.SMALL_BAUXITE);
        for (Ore.Grade grade : Ore.Grade.values()) {
            CreativeTabs.accept(out, Items.BAUXITE_ORES, grade);
        }
        CreativeTabs.accept(out, Blocks.SMALL_GALENA);
        for (Ore.Grade grade : Ore.Grade.values()) {
            CreativeTabs.accept(out, Items.GALENA_ORES, grade);
        }
        CreativeTabs.accept(out, Blocks.SMALL_URANINITE);
        for (Ore.Grade grade : Ore.Grade.values()) {
            CreativeTabs.accept(out, Items.URANINITE_ORES, grade);
        }
        for (IEMetal iEMetal : IEMetal.values()) {
            for (IEMetal.ItemType itemType : IEMetal.ItemType.values()) {
                CreativeTabs.accept(out, Items.METAL_ITEMS, iEMetal, itemType);
            }
        }
        CreativeTabs.accept(out, Items.BAUXITE_POWDER);
        CreativeTabs.accept(out, Items.GALENA_POWDER);
        CreativeTabs.accept(out, Items.URANINITE_POWDER);
        for (IEMetal iEMetal : IEMetal.values()) {
            CreativeTabs.accept(out, Items.METAL_FLUID_BUCKETS, iEMetal);
        }
        CreativeTabs.accept(out, Blocks.QUARTZ_BLOCK);
        CreativeTabs.accept(out, Blocks.BUDDING_QUARTZ);
        CreativeTabs.accept(out, Items.QUARTZ_SHARD);
        CreativeTabs.accept(out, Blocks.QUARTZ_CLUSTER);
        CreativeTabs.accept(out, Blocks.LARGE_QUARTZ_BUD);
        CreativeTabs.accept(out, Blocks.MEDIUM_QUARTZ_BUD);
        CreativeTabs.accept(out, Blocks.SMALL_QUARTZ_BUD);
        for (IEMetal iEMetal : IEMetal.values()) {
            for (Enum enum_ : IEMetal.BlockType.values()) {
                CreativeTabs.accept(out, Blocks.METALS, iEMetal, enum_);
            }
        }
        for (Rock rock : Rock.values()) {
            for (Enum enum_ : Ore.Grade.values()) {
                CreativeTabs.accept(out, Blocks.BAUXITE_ORES, rock, enum_);
                CreativeTabs.accept(out, Blocks.GALENA_ORES, rock, enum_);
                CreativeTabs.accept(out, Blocks.URANINITE_ORES, rock, enum_);
            }
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == net.minecraft.world.item.Items.f_41852_) {
            TFC_IE_Addon.LOGGER.error("BlockItem with no Item added to creative tab: " + reg);
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    private static <T> void consumeOurs(IForgeRegistry<T> registry, Consumer<T> consumer) {
        for (Object value : registry) {
            if (!Objects.requireNonNull(registry.getKey(value)).m_135827_().equals("tfc_ie_addon")) continue;
            consumer.accept(value);
        }
    }
}

