/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.mixin;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import java.util.Objects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IngredientFluidStack.class})
public abstract class IngredientFluidStackMixin {
    @Shadow
    @Final
    private FluidTagInput fluidTagInput;
    @Shadow
    ItemStack[] cachedStacks;

    @Inject(method={"getItems"}, at={@At(value="HEAD")}, cancellable=true)
    public void getItems(CallbackInfoReturnable<ItemStack[]> cir) {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.fluidTagInput.getMatchingFluidStacks().stream().flatMap(fluid -> Helpers.streamAllTagValues((TagKey)TFCTags.Items.FLUID_ITEM_INGREDIENT_EMPTY_CONTAINERS, (IForgeRegistry)ForgeRegistries.ITEMS).map(item -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)Helpers.getCapability((ICapabilityProvider)stack, (Capability)Capabilities.FLUID_ITEM);
                if (fluidHandler != null) {
                    fluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
                    FluidStack content = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if (content.getFluid() == fluid.getFluid() && content.getAmount() >= fluid.getAmount()) {
                        return fluidHandler.getContainer();
                    }
                }
                return null;
            })).filter(Objects::nonNull).toArray(ItemStack[]::new);
        }
        cir.setReturnValue((Object)this.cachedStacks);
    }
}

