/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.util;

import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.util.NonNullFunction;

@MethodsReturnNonnullByDefault
public enum IEMetal implements RegistryMetal
{
    ELECTRUM(16561994, MapColor.f_283832_, Rarity.EPIC, TFCTiers.WROUGHT_IRON, (ArmorMaterial)TFCArmorMaterials.WROUGHT_IRON, Metal.Tier.TIER_IV),
    CONSTANTAN(15499368, MapColor.f_283750_, Rarity.EPIC, TFCTiers.STEEL, (ArmorMaterial)TFCArmorMaterials.STEEL, Metal.Tier.TIER_IV),
    ALUMINUM(0xCCC1BC, MapColor.f_283744_, Rarity.COMMON, TFCTiers.BRONZE, (ArmorMaterial)TFCArmorMaterials.BRONZE, Metal.Tier.TIER_I),
    LEAD(4407117, MapColor.f_283908_, Rarity.RARE, TFCTiers.BLACK_BRONZE, (ArmorMaterial)TFCArmorMaterials.WROUGHT_IRON, Metal.Tier.TIER_III),
    URANIUM(7572076, MapColor.f_283856_, Rarity.EPIC, TFCTiers.STEEL, (ArmorMaterial)TFCArmorMaterials.STEEL, Metal.Tier.TIER_IV);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final int color;
    private final MapColor mapColor;
    private final Rarity rarity;
    private final Tier toolTier;
    private final ArmorMaterial armorTier;
    private final Metal.Tier metalTier;

    private IEMetal(int color, MapColor mapColor, Rarity rarity, Tier toolTier, ArmorMaterial armorTier, Metal.Tier metalTier) {
        this.mapColor = mapColor;
        this.color = color;
        this.rarity = rarity;
        this.toolTier = toolTier;
        this.armorTier = armorTier;
        this.metalTier = metalTier;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public int getColor() {
        return this.color;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Tier toolTier() {
        return this.toolTier;
    }

    public ArmorMaterial armorTier() {
        return this.armorTier;
    }

    public Metal.Tier metalTier() {
        return this.metalTier;
    }

    public MapColor mapColor() {
        return this.mapColor;
    }

    public Supplier<Block> getFullBlock() {
        return (Supplier)Blocks.METALS.get((Object)this).get((Object)BlockType.BLOCK);
    }

    public static enum BlockType {
        BLOCK(metal -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BLOCK_SLAB(metal -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BLOCK_STAIRS(metal -> new StairBlock(() -> ((Block)metal.getFullBlock().get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));

        private final Function<RegistryMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final String serializedName;

        private BlockType(Function<RegistryMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        private BlockType(Function<RegistryMetal, Block> blockFactory) {
            this(blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(RegistryMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public String createName(RegistryMetal metal) {
            if (this == BLOCK_SLAB || this == BLOCK_STAIRS) {
                return BLOCK.createName(metal) + (this == BLOCK_SLAB ? "_slab" : "_stairs");
            }
            return "metal/" + this.serializedName + "/" + metal.m_7912_();
        }
    }

    public static enum ItemType {
        SHEET((NonNullFunction<IEMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
        DOUBLE_INGOT((NonNullFunction<IEMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties())));

        private final NonNullFunction<IEMetal, Item> itemFactory;

        private ItemType(NonNullFunction<IEMetal, Item> itemFactory) {
            this.itemFactory = itemFactory;
        }

        public Item create(IEMetal metal) {
            return (Item)this.itemFactory.apply((Object)metal);
        }
    }
}

