/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.world.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.nmagpie.tfc_ie_addon.common.blocks.BuddingQuartzBlock;
import com.nmagpie.tfc_ie_addon.world.feature.GeodeConfig;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;

public class GeodeFeature
extends Feature<GeodeConfig> {
    public GeodeFeature(Codec<GeodeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GeodeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        GeodeConfig config = (GeodeConfig)context.m_159778_();
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(level.m_7328_()));
        NormalNoise normalnoise = NormalNoise.m_230504_((RandomSource)worldgenrandom, (int)-4, (double[])new double[]{1.0});
        boolean cracked = (double)random.m_188501_() < (double)0.95f;
        LinkedList list = Lists.newLinkedList();
        LinkedList crackBlocks = Lists.newLinkedList();
        UniformInt outerWall = UniformInt.m_146622_((int)4, (int)6);
        UniformInt pointOffset = UniformInt.m_146622_((int)1, (int)2);
        int distributionPoint = UniformInt.m_146622_((int)3, (int)4).m_214085_(random);
        double relativeDistributionPoint = (double)distributionPoint / (double)outerWall.m_142737_();
        double fillLimit = 1.0 / Math.sqrt(1.7);
        double innerLimit = 1.0 / Math.sqrt(2.2 + relativeDistributionPoint);
        double middleLimit = 1.0 / Math.sqrt(3.2 + relativeDistributionPoint);
        double outerLimit = 1.0 / Math.sqrt(4.2 + relativeDistributionPoint);
        double distWeight = 1.0 / Math.sqrt(2.0 + random.m_188500_() / 2.0 + (distributionPoint > 3 ? relativeDistributionPoint : 0.0));
        int invalid = 0;
        for (int i1 = 0; i1 < distributionPoint; ++i1) {
            int z;
            int y;
            int x = outerWall.m_214085_(random);
            BlockPos offsetPos = origin.m_7918_(x, y = outerWall.m_214085_(random), z = outerWall.m_214085_(random));
            BlockState found = level.m_8055_(offsetPos);
            if ((found.m_60795_() || Helpers.isBlock((BlockState)found, (TagKey)BlockTags.f_144289_)) && ++invalid > 1) {
                return false;
            }
            list.add(Pair.of((Object)offsetPos, (Object)pointOffset.m_214085_(random)));
        }
        if (cracked) {
            int type = random.m_188503_(4);
            int dist = distributionPoint * 2 + 1;
            if (type == 0) {
                crackBlocks.add(origin.m_7918_(dist, 7, 0));
                crackBlocks.add(origin.m_7918_(dist, 5, 0));
                crackBlocks.add(origin.m_7918_(dist, 1, 0));
            } else if (type == 1) {
                crackBlocks.add(origin.m_7918_(0, 7, dist));
                crackBlocks.add(origin.m_7918_(0, 5, dist));
                crackBlocks.add(origin.m_7918_(0, 1, dist));
            } else if (type == 2) {
                crackBlocks.add(origin.m_7918_(dist, 7, dist));
                crackBlocks.add(origin.m_7918_(dist, 5, dist));
                crackBlocks.add(origin.m_7918_(dist, 1, dist));
            } else {
                crackBlocks.add(origin.m_7918_(0, 7, 0));
                crackBlocks.add(origin.m_7918_(0, 5, 0));
                crackBlocks.add(origin.m_7918_(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate predicate = GeodeFeature.m_204735_((TagKey)BlockTags.f_144287_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-16, -16, -16), (BlockPos)origin.m_7918_(16, 16, 16))) {
            double noise = normalnoise.m_75380_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) * 0.05;
            double pointAt = 0.0;
            double crackWeight = 0.0;
            for (Pair pair : list) {
                pointAt += Mth.m_264555_((double)(pos.m_123331_((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + noise;
            }
            for (BlockPos crackPos : crackBlocks) {
                crackWeight += Mth.m_264555_((double)(pos.m_123331_((Vec3i)crackPos) + 2.0)) + noise;
            }
            if (pointAt < outerLimit) continue;
            if (cracked && crackWeight >= distWeight && pointAt < fillLimit) {
                this.m_159742_(level, pos, Blocks.f_50016_.m_49966_(), predicate);
                for (Direction d : Helpers.DIRECTIONS) {
                    BlockPos relativePos = pos.m_121945_(d);
                    FluidState fluid = level.m_6425_(relativePos);
                    if (fluid.m_76178_()) continue;
                    level.m_186469_(relativePos, fluid.m_76152_(), 0);
                }
                continue;
            }
            if (pointAt >= fillLimit) {
                this.m_159742_(level, pos, config.filling().m_216820_(random).orElse(Blocks.f_50016_.m_49966_()), predicate);
                continue;
            }
            if (pointAt >= innerLimit) {
                boolean flag1 = (double)random.m_188501_() < 0.083;
                this.m_159742_(level, pos, (BlockState)config.inner().m_216820_(random).orElseThrow(), predicate);
                if (!flag1 || !((double)random.m_188501_() < 0.35)) continue;
                list2.add(pos.m_7949_());
                continue;
            }
            if (pointAt >= middleLimit) {
                this.m_159742_(level, pos, config.middle(), predicate);
                continue;
            }
            if (!(pointAt >= outerLimit)) continue;
            this.m_159742_(level, pos, config.outer(), predicate);
        }
        block5: for (BlockPos blockpos4 : list2) {
            BlockState blockstate1 = (BlockState)config.innerPlacements().m_216820_(random).orElseThrow();
            for (Direction direction : Helpers.DIRECTIONS) {
                if (blockstate1.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    blockstate1 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
                }
                BlockPos blockpos5 = blockpos4.m_121945_(direction);
                BlockState blockstate2 = level.m_8055_(blockpos5);
                if (blockstate1.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    blockstate1 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(blockstate2.m_60819_().m_76170_()));
                }
                if (!BuddingQuartzBlock.m_152734_((BlockState)blockstate2)) continue;
                this.m_159742_(level, blockpos5, blockstate1, predicate);
                continue block5;
            }
        }
        return true;
    }
}

