/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.common.blocks;

import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import com.nmagpie.tfc_ie_addon.common.items.Items;
import com.nmagpie.tfc_ie_addon.util.IEMetal;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class Fluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"tfc_ie_addon");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"tfc_ie_addon");
    public static final Map<IEMetal, FluidHolder<BaseFlowingFluid>> METALS = Helpers.mapOf(IEMetal.class, metal -> Fluids.register("metal/" + metal.getSerializedName(), properties -> properties.block((Supplier)Blocks.METAL_FLUIDS.get(metal)).bucket((Supplier)Items.METAL_FLUID_BUCKETS.get(metal)).explosionResistance(100.0f), Fluids.lavaLike().descriptionId("fluid.tfc_ie_addon.metal." + metal.getSerializedName()), MoltenFluid.Source::new, MoltenFluid.Flowing::new));

    private static FluidType.Properties lavaLike() {
        return FluidType.Properties.create().adjacentPathType(PathType.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(3000).viscosity(6000).temperature(1300).canConvertToSource(false).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static <F extends FlowingFluid> FluidHolder<F> register(String name, Consumer<BaseFlowingFluid.Properties> builder, FluidType.Properties typeProperties, Function<BaseFlowingFluid.Properties, F> sourceFactory, Function<BaseFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid(FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new FluidType(typeProperties), sourceFactory, flowingFactory);
    }
}

