/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.common.items;

import com.nmagpie.tfc_ie_addon.common.blocks.Fluids;
import com.nmagpie.tfc_ie_addon.common.items.Drillhead;
import com.nmagpie.tfc_ie_addon.util.IEMetal;
import com.nmagpie.tfc_ie_addon.util.IEOre;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Items {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"tfc_ie_addon");
    public static final TFCItems.ItemId QUARTZ_SHARD = Items.register("mineral/quartz_shard");
    public static final TFCItems.ItemId WIRECUTTER_HEAD = Items.register("tool_head/wirecutter");
    public static final TFCItems.ItemId HAMMER_HEAD = Items.register("tool_head/ie_hammer");
    public static final TFCItems.ItemId MOLD_SHEET = Items.register("mold_sheet", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final TFCItems.ItemId MOLD_BLOCK = Items.register("mold_block", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final TFCItems.ItemId DRILLHEAD_BLACK_STEEL = Items.register("drillhead_black_steel", () -> new Drillhead(Drillhead.BLACK_STEEL));
    public static final TFCItems.ItemId DRILLHEAD_BLUE_STEEL = Items.register("drillhead_blue_steel", () -> new Drillhead(Drillhead.BLUE_STEEL));
    public static final TFCItems.ItemId DRILLHEAD_RED_STEEL = Items.register("drillhead_red_steel", () -> new Drillhead(Drillhead.RED_STEEL));
    public static final TFCItems.ItemId TREATED_WOOD_LUMBER = Items.register("treated_wood_lumber");
    public static final Map<IEOre, Map<Ore.Grade, TFCItems.ItemId>> ORES = Helpers.mapOf(IEOre.class, ore -> Helpers.mapOf(Ore.Grade.class, grade -> Items.register("ore/" + grade.name() + "_" + ore.name())));
    public static final Map<IEOre, TFCItems.ItemId> POWDERS = Helpers.mapOf(IEOre.class, ore -> Items.register("powder/" + ore.name()));
    public static final Map<IEMetal, Map<IEMetal.ItemType, TFCItems.ItemId>> METAL_ITEMS = Helpers.mapOf(IEMetal.class, metal -> Helpers.mapOf(IEMetal.ItemType.class, type -> Items.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((IEMetal)((Object)metal)))));
    public static final Map<IEMetal, TFCItems.ItemId> METAL_FLUID_BUCKETS = Helpers.mapOf(IEMetal.class, metal -> Items.register("bucket/metal/" + metal.name(), () -> new BucketItem((Fluid)Fluids.METALS.get(metal).getSource(), new Item.Properties().craftRemainder(net.minecraft.world.item.Items.BUCKET).stacksTo(1))));

    private static TFCItems.ItemId register(String name) {
        return Items.register(name, () -> new Item(new Item.Properties()));
    }

    private static TFCItems.ItemId register(String name, Item.Properties properties) {
        return new TFCItems.ItemId(ITEMS.register(name.toLowerCase(Locale.ROOT), () -> new Item(properties)));
    }

    private static TFCItems.ItemId register(String name, Supplier<Item> item) {
        return new TFCItems.ItemId(ITEMS.register(name.toLowerCase(Locale.ROOT), item));
    }
}

