/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.mixin;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.DynamoBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import com.nmagpie.tfc_ie_addon.config.Config;
import net.dries007.tfc.common.blockentities.rotation.RotationSinkBlockEntity;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.SinkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamoBlockEntity.class})
public abstract class DynamoBlockEntityMixin
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEServerTickableBE,
RotationSinkBlockEntity {
    @Shadow
    @Final
    private IRotationAcceptor rotationCap;
    @Unique
    private SinkNode tfc_ie_addon$node;

    public DynamoBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstructor(BlockPos pos, BlockState state, CallbackInfo ci) {
        this.tfc_ie_addon$node = new SinkNode(pos, this.getFacing()){

            @NotNull
            public String toString() {
                return "Dynamo[pos=%s, direction=%s]".formatted(this.pos(), DynamoBlockEntityMixin.this.getFacing());
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.performNetworkAction(NetworkAction.ADD);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    public void setRemovedIE() {
        super.setRemovedIE();
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @NotNull
    public Node getRotationNode() {
        return this.tfc_ie_addon$node;
    }

    public void tickServer() {
        if (this.tfc_ie_addon$node.rotation() != null) {
            this.rotationCap.inputRotation(Math.abs((double)(this.tfc_ie_addon$node.rotation().speed() * 500.0f) * Config.SERVER.tfcRotationalEnergyModifier.get()));
        }
    }
}

