/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.config;

import java.util.function.Function;
import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.IntValue crucibleExternalHeaterFEPerTick;
    public final ForgeConfigSpec.IntValue crucibleExternalHeaterTemperature;
    public final ForgeConfigSpec.DoubleValue tfcWaterWheelEnergyModifier;
    public final ForgeConfigSpec.DoubleValue tfcWindmillEnergyModifier;
    public final ForgeConfigSpec.EnumValue<Size> crateMaximumItemSize;

    ServerConfig(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("tfc_ie_addon.config.server." + name);
        innerBuilder.push("crucibleExternalHeater");
        this.crucibleExternalHeaterFEPerTick = builder.apply("crucibleExternalHeaterFEPerTick").comment("The amount of FE an external heater consumes per tick when heating a crucible.").defineInRange("crucibleExternalHeaterFEPerTick", 20, 0, 32000);
        this.crucibleExternalHeaterTemperature = builder.apply("crucibleExternalHeaterTemperature").comment("The maximum temperature a crucible reaches when heated by an external heater.").defineInRange("crucibleExternalHeaterTemperature", 2000, 0, Integer.MAX_VALUE);
        innerBuilder.pop().push("tfcWaterWheel");
        this.tfcWaterWheelEnergyModifier = builder.apply("tfcWaterWheelEnergyModifier").comment("A modifier to apply to the energy generation of a TFC water wheel on a kinetic dynamo.").defineInRange("tfcWaterWheelEnergyModifier", 1.0, 0.001, 1000.0);
        innerBuilder.pop().push("tfcWindmill");
        this.tfcWindmillEnergyModifier = builder.apply("tfcWindmillEnergyModifier").comment("A modifier to apply to the energy generation of a TFC windmill on a kinetic dynamo.").defineInRange("tfcWindmillEnergyModifier", 1.0, 0.001, 1000.0);
        innerBuilder.pop().push("crate");
        this.crateMaximumItemSize = builder.apply("crateMaximumItemSize").comment("The largest (inclusive) size of an item that is allowed in a wooden storage crate or reinforced storage crate.").defineEnum("crateMaximumItemSize", (Enum)Size.VERY_LARGE);
        innerBuilder.pop();
    }
}

