/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.util;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import com.nmagpie.tfc_ie_addon.config.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class IEHeatHandler {

    public static class Provider
    implements ICapabilityProvider {
        private final CrucibleHeater heater;
        private final LazyOptional<ExternalHeaterHandler.IExternalHeatable> lazy;

        public Provider(BlockEntity blockEntity) {
            this.heater = new CrucibleHeater(blockEntity);
            this.lazy = LazyOptional.of(() -> this.heater);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return ExternalHeaterHandler.CAPABILITY.orEmpty(cap, this.lazy);
        }

        public void invalidate() {
            this.lazy.invalidate();
        }
    }

    public static class CrucibleHeater
    implements ExternalHeaterHandler.IExternalHeatable {
        private final BlockEntity blockEntity;

        public CrucibleHeater(BlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public int doHeatTick(int energyAvailable, boolean redstone) {
            return this.blockEntity.getCapability(HeatCapability.BLOCK_CAPABILITY).map(handler -> {
                int FEPerTick = (Integer)Config.SERVER.crucibleExternalHeaterFEPerTick.get();
                if (energyAvailable >= FEPerTick && !redstone) {
                    handler.setTemperature((float)((Integer)Config.SERVER.crucibleExternalHeaterTemperature.get()).intValue());
                    return FEPerTick;
                }
                handler.setTemperature(0.0f);
                return 0;
            }).orElse(0);
        }
    }
}

