/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.util;

import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.LevelTier;
import net.dries007.tfc.common.TFCTiers;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public enum IEMetal implements StringRepresentable
{
    ELECTRUM(16561994, MapColor.COLOR_YELLOW, Rarity.EPIC, TFCTiers.COPPER),
    CONSTANTAN(15499368, MapColor.COLOR_ORANGE, Rarity.EPIC, TFCTiers.COPPER),
    ALUMINUM(0xCCC1BC, MapColor.CLAY, Rarity.COMMON, TFCTiers.WROUGHT_IRON),
    LEAD(4407117, MapColor.TERRACOTTA_BLUE, Rarity.RARE, TFCTiers.COPPER),
    URANIUM(7572076, MapColor.TERRACOTTA_GREEN, Rarity.EPIC, TFCTiers.WROUGHT_IRON);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final int color;
    private final MapColor mapColor;
    private final Rarity rarity;
    private final LevelTier tier;

    private IEMetal(int color, MapColor mapColor, Rarity rarity, LevelTier tier) {
        this.mapColor = mapColor;
        this.color = color;
        this.rarity = rarity;
        this.tier = tier;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public int getColor() {
        return this.color;
    }

    public MapColor mapColor() {
        return this.mapColor;
    }

    public Rarity rarity() {
        return this.rarity;
    }

    public LevelTier tier() {
        return this.tier;
    }

    public Supplier<Block> getFullBlock() {
        return (Supplier)Blocks.METALS.get((Object)this).get((Object)BlockType.BLOCK);
    }

    public static enum BlockType {
        BLOCK(metal -> new Block(BlockBehaviour.Properties.of().mapColor(metal.mapColor()).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL))),
        BLOCK_SLAB(metal -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(metal.mapColor()).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL))),
        BLOCK_STAIRS(metal -> new StairBlock(metal.getFullBlock().get().defaultBlockState(), BlockBehaviour.Properties.of().mapColor(metal.mapColor()).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));

        private final Function<IEMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final String serializedName;

        private BlockType(Function<IEMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        private BlockType(Function<IEMetal, Block> blockFactory) {
            this(blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(IEMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public String createName(IEMetal metal) {
            if (this == BLOCK_SLAB || this == BLOCK_STAIRS) {
                return BLOCK.createName(metal) + (this == BLOCK_SLAB ? "_slab" : "_stairs");
            }
            return "metal/" + this.serializedName + "/" + metal.getSerializedName();
        }
    }

    public static enum ItemType {
        SHEET(metal -> new Item(new Item.Properties().rarity(metal.rarity()))),
        DOUBLE_INGOT(metal -> new Item(new Item.Properties().rarity(metal.rarity())));

        private final Function<IEMetal, Item> itemFactory;

        private ItemType(Function<IEMetal, Item> itemFactory) {
            this.itemFactory = itemFactory;
        }

        public Item create(IEMetal metal) {
            return this.itemFactory.apply(metal);
        }
    }
}

