/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.util;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.mixin.accessors.CropBlockAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.nmagpie.tfc_ie_addon.TFC_IE_Addon;
import java.util.Collection;
import java.util.Map;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeMapCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class ModClocheRenderFunctions {
    public static void init() {
        for (SoilBlockType.Variant soil : SoilBlockType.Variant.values()) {
            String soilName = soil.name().toLowerCase();
            ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)("block/farmland/" + soilName));
            ClocheRecipe.registerSoilTexture((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)((Map)TFCBlocks.SOIL.get(SoilBlockType.DIRT)).get(soil)}), (ResourceLocation)rl);
        }
    }

    public static void register() {
        ModClocheRenderFunctions.register("doublecroptfc", RenderFunctionDoubleCropTFC.CODEC);
    }

    private static void register(String path, DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec) {
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put((Object)TFC_IE_Addon.identifier(path), codec);
    }

    private static Pair<IntegerProperty, Integer> getCropAge(Block block) throws IllegalArgumentException {
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return Pair.of((Object)((CropBlockAccess)crop).invokeGetAgeProperty(), (Object)crop.getMaxAge());
        }
        for (Property prop : block.defaultBlockState().getProperties()) {
            IntegerProperty intProp;
            int max;
            if (!"age".equals(prop.getName()) || !(prop instanceof IntegerProperty) || (max = (intProp = (IntegerProperty)prop).getPossibleValues().stream().max(Integer::compare).orElse(-1).intValue()) <= 0) continue;
            return Pair.of((Object)intProp, (Object)max);
        }
        throw new IllegalArgumentException("Block " + block.getDescriptionId() + " is not a valid crop block");
    }

    public static class RenderFunctionDoubleCropTFC
    implements ClocheRenderFunction {
        public static final DualMapCodec<? super RegistryFriendlyByteBuf, RenderFunctionDoubleCropTFC> CODEC = DualCompositeMapCodecs.composite((DualMapCodec)DualCodecs.registryEntry((Registry)BuiltInRegistries.BLOCK).fieldOf("block"), r -> r.cropBlock, (DualMapCodec)DualCodecs.INT.fieldOf("doublingAge"), r -> r.doublingAge, RenderFunctionDoubleCropTFC::new);
        final Block cropBlock;
        IntegerProperty ageProperty;
        int maxAge;
        final int doublingAge;

        public RenderFunctionDoubleCropTFC(Block cropBlock, int doublingAge) {
            this.cropBlock = cropBlock;
            Pair<IntegerProperty, Integer> cropAge = ModClocheRenderFunctions.getCropAge(cropBlock);
            this.ageProperty = (IntegerProperty)cropAge.getFirst();
            this.maxAge = (Integer)cropAge.getSecond();
            this.doublingAge = doublingAge;
        }

        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(this.maxAge, Math.round((float)this.maxAge * growth));
            if (age >= this.doublingAge) {
                Transformation top = new Transformation(new Vector3f(0.0f, 1.0f, 0.0f), null, null, null);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age))), (Object)new Transformation(null)), (Object)Pair.of((Object)((BlockState)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age))).setValue((Property)DoubleCropBlock.PART, (Comparable)DoubleCropBlock.Part.TOP)), (Object)top));
            }
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age))), (Object)new Transformation(null)));
        }

        public DualMapCodec<? super RegistryFriendlyByteBuf, ? extends ClocheRenderFunction> codec() {
            return CODEC;
        }
    }
}

