/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import com.nmagpie.tfc_ie_addon.common.blocks.Blocks;
import com.nmagpie.tfc_ie_addon.common.blocks.Fluids;
import com.nmagpie.tfc_ie_addon.config.Config;
import java.util.Objects;
import java.util.stream.Stream;
import net.dries007.tfc.client.ClientEventHandler;
import net.dries007.tfc.client.extensions.FluidRendererExtension;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;

public class ClientEvents {
    public static void init(IEventBus bus) {
        bus.addListener(ClientEvents::clientSetup);
        bus.addListener(ClientEvents::registerColorHandlerItems);
        bus.addListener(ClientEvents::registerExtensions);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.cutout();
        Stream.of(Blocks.BUDDING_QUARTZ, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_CLUSTER, Blocks.LARGE_QUARTZ_BUD, Blocks.MEDIUM_QUARTZ_BUD, Blocks.SMALL_QUARTZ_BUD).forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        Blocks.SMALL_ORES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        Blocks.ORES.values().forEach(map -> map.values().forEach(inner -> inner.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout))));
        ClientEvents.setupManual();
    }

    private static void setupManual() {
        ManualHelper.addConfigGetter(str -> switch (str) {
            case "crucibleExternalHeaterFEPerTick" -> Config.SERVER.crucibleExternalHeaterFEPerTick.get();
            case "crucibleExternalHeaterTemperature" -> Config.SERVER.crucibleExternalHeaterTemperature.get();
            default -> -1;
        });
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            if (!Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)fluid)).getNamespace().equals("tfc_ie_addon")) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{fluid.getBucket()});
        }
    }

    public static void registerExtensions(RegisterClientExtensionsEvent event) {
        Fluids.METALS.forEach((metal, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(0xFF000000 | metal.getColor(), ClientEventHandler.MOLTEN_STILL, ClientEventHandler.MOLTEN_FLOW, null, null), new FluidType[]{holder.getType()}));
    }
}

