/*
 * Decompiled with CFR 0.152.
 */
package com.nmagpie.tfc_ie_addon.common.blocks;

import com.nmagpie.tfc_ie_addon.common.blocks.BuddingQuartzBlock;
import com.nmagpie.tfc_ie_addon.common.blocks.Fluids;
import com.nmagpie.tfc_ie_addon.common.items.Items;
import com.nmagpie.tfc_ie_addon.util.IECrop;
import com.nmagpie.tfc_ie_addon.util.IEMetal;
import com.nmagpie.tfc_ie_addon.util.IEOre;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Blocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"tfc_ie_addon");
    public static final TFCBlocks.Id<AmethystBlock> QUARTZ_BLOCK = Blocks.register("mineral/quartz_block", () -> new AmethystBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(1.5f).sound(SoundType.STONE).requiresCorrectToolForDrops()));
    public static final TFCBlocks.Id<BuddingQuartzBlock> BUDDING_QUARTZ = Blocks.register("mineral/budding_quartz", () -> new BuddingQuartzBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).randomTicks().strength(1.5f).sound(SoundType.STONE).requiresCorrectToolForDrops()));
    public static final TFCBlocks.Id<AmethystClusterBlock> QUARTZ_CLUSTER = Blocks.register("mineral/quartz_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).noOcclusion().randomTicks().sound(SoundType.GLASS).strength(1.5f).lightLevel(light -> 5)));
    public static final TFCBlocks.Id<AmethystClusterBlock> LARGE_QUARTZ_BUD = Blocks.register("mineral/large_quartz_bud", () -> new AmethystClusterBlock(5.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)QUARTZ_CLUSTER.get())).sound(SoundType.GLASS).lightLevel(light -> 4)));
    public static final TFCBlocks.Id<AmethystClusterBlock> MEDIUM_QUARTZ_BUD = Blocks.register("mineral/medium_quartz_bud", () -> new AmethystClusterBlock(4.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)QUARTZ_CLUSTER.get())).sound(SoundType.GLASS).lightLevel(light -> 2)));
    public static final TFCBlocks.Id<AmethystClusterBlock> SMALL_QUARTZ_BUD = Blocks.register("mineral/small_quartz_bud", () -> new AmethystClusterBlock(3.0f, 4.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)QUARTZ_CLUSTER.get())).sound(SoundType.GLASS).lightLevel(light -> 1)));
    public static final Map<Rock, Map<IEOre, Map<Ore.Grade, TFCBlocks.Id<Block>>>> ORES = Helpers.mapOf(Rock.class, rock -> Helpers.mapOf(IEOre.class, ore -> Helpers.mapOf(Ore.Grade.class, grade -> Blocks.register("ore/" + grade.name() + "_" + ore.name() + "/" + rock.name(), () -> ore.create((RegistryRock)rock)))));
    public static final Map<IEOre, TFCBlocks.Id<Block>> SMALL_ORES = Helpers.mapOf(IEOre.class, ore -> Blocks.register("ore/small_" + ore.name(), () -> GroundcoverBlock.looseOre((BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).strength(0.05f, 0.0f).sound(SoundType.NETHER_ORE).noCollission().pushReaction(PushReaction.DESTROY))));
    public static final Map<IEMetal, Map<IEMetal.BlockType, TFCBlocks.Id<Block>>> METALS = Helpers.mapOf(IEMetal.class, metal -> Helpers.mapOf(IEMetal.BlockType.class, type -> Blocks.register(type.createName((IEMetal)((Object)metal)), type.create((IEMetal)((Object)metal)), type.createBlockItem(new Item.Properties()))));
    public static final Map<IEMetal, TFCBlocks.Id<LiquidBlock>> METAL_FLUIDS = Helpers.mapOf(IEMetal.class, metal -> Blocks.registerNoItem("fluid/metal/" + metal.name(), () -> new LiquidBlock(Fluids.METALS.get(metal).getSource(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.LAVA).noLootTable())));
    public static final Map<IECrop, TFCBlocks.Id<Block>> CROPS = Helpers.mapOf(IECrop.class, crop -> Blocks.registerNoItem("crop/" + crop.name(), crop::create));
    public static final Map<IECrop, TFCBlocks.Id<Block>> DEAD_CROPS = Helpers.mapOf(IECrop.class, crop -> Blocks.registerNoItem("dead_crop/" + crop.name(), crop::createDead));
    public static final Map<IECrop, TFCBlocks.Id<Block>> WILD_CROPS = Helpers.mapOf(IECrop.class, crop -> Blocks.register("wild_crop/" + crop.name(), crop::createWild));

    private static <T extends Block> TFCBlocks.Id<T> registerNoItem(String name, Supplier<T> blockSupplier) {
        return Blocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> TFCBlocks.Id<T> register(String name, Supplier<T> blockSupplier) {
        return Blocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties()));
    }

    private static <T extends Block> TFCBlocks.Id<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return Blocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> TFCBlocks.Id<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return new TFCBlocks.Id(RegistrationHelpers.registerBlock(BLOCKS, Items.ITEMS, (String)name, blockSupplier, blockItemFactory));
    }
}

