/*
 * Decompiled with CFR 0.152.
 */
package me.frogtato.dragoneggmod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import me.frogtato.dragoneggmod.client.DragonEggModClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class EggCrownHeadLayer<S extends PlayerRenderState, M extends PlayerModel>
extends RenderLayer<S, M> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dragoneggmod", (String)"textures/misc/crown.png");
    private final ModelPart part;

    public EggCrownHeadLayer(RenderLayerParent<S, M> renderer) {
        super(renderer);
        EnumSet<Direction> faces = EnumSet.allOf(Direction.class);
        ModelPart.Cube box = new ModelPart.Cube(0, 0, -0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, 4.5f, 4.5f, 4.5f, false, 4.0f, 2.0f, faces);
        this.part = new ModelPart(List.of(box), Map.of());
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S renderState, float yRot, float xRot) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Player foundPlayer = null;
        for (Player player : mc.level.players()) {
            if (player.getId() != ((PlayerRenderState)renderState).id) continue;
            foundPlayer = player;
            break;
        }
        if (foundPlayer == null) {
            return;
        }
        if (!DragonEggModClient.hasCrown(foundPlayer)) {
            return;
        }
        poseStack.pushPose();
        ((PlayerModel)this.getParentModel()).head.translateAndRotate(poseStack);
        poseStack.translate(0.0, -0.25, 0.0);
        if (!((PlayerRenderState)renderState).headItem.isEmpty() | !((PlayerRenderState)renderState).headEquipment.is(Items.AIR)) {
            poseStack.scale(1.12f, 1.12f, 1.12f);
        }
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.part.render(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

