/*
 * Decompiled with CFR 0.152.
 */
package me.frogtato.dragoneggmod.mob_effect;

import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class EggEffect
extends MobEffect {
    private int duration = 0;

    public EggEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(ServerLevel level, LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        PlayerTeam newTeam = this.getOrCreateTeam((Level)level, "dragoneggmod.egg_team");
        newTeam.setColor(ChatFormatting.DARK_PURPLE);
        level.getScoreboard().addPlayerToTeam(player.getGameProfile().getName(), newTeam);
        if (this.duration == 1) {
            level.getScoreboard().removePlayerFromTeam(player.getGameProfile().getName(), newTeam);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int amplifier) {
        this.duration = pDuration;
        return true;
    }

    private PlayerTeam getOrCreateTeam(Level level, String teamName) {
        Scoreboard scoreboard = level.getScoreboard();
        PlayerTeam team = scoreboard.getPlayerTeam(teamName);
        if (team == null) {
            team = scoreboard.addPlayerTeam(teamName);
        }
        return team;
    }
}

