/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetHoverInfo;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import net.minecraft.class_332;
import net.smok.macrofactory.gui.ButtonSwitch;
import net.smok.macrofactory.gui.PositionAlignment;
import net.smok.macrofactory.gui.Rect;
import net.smok.macrofactory.gui.RectContainer;
import net.smok.macrofactory.gui.utils.TextFieldListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiEntry<T>
extends WidgetConfigOptionBase<T> {
    protected final IKeybindConfigGui host;
    private final ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields = new ArrayList();
    private final RectContainer rectContainer;

    public GuiEntry(int x, int y, int width, int lineHeight, int space, WidgetListConfigOptionsBase<?, ?> parent, T entry, int listIndex, IKeybindConfigGui host) {
        super(x, y, width, lineHeight, parent, entry, listIndex);
        this.host = host;
        this.rectContainer = new RectContainer(space, 2, x, x + width, y, lineHeight - 2);
    }

    public abstract void init();

    protected GuiTextFieldGeneric addTextField(PositionAlignment alignment, IConfigValue config) {
        return this.addTextField(alignment, config, config.getComment(), 256);
    }

    protected GuiTextFieldGeneric addTextField(PositionAlignment alignment, IConfigValue config, int maxTextfieldTextLength) {
        return this.addTextField(alignment, config, config.getComment(), maxTextfieldTextLength);
    }

    protected GuiTextFieldGeneric addTextField(PositionAlignment alignment, IConfigValue config, @Nullable String comment, int maxTextfieldTextLength) {
        Rect rect = this.addRect(alignment);
        GuiTextFieldGeneric field = new GuiTextFieldGeneric(rect.x() + 2, rect.y() + 2, rect.width() - 4, rect.height() - 4, this.textRenderer);
        field.method_1880(maxTextfieldTextLength);
        field.method_1852(config.getStringValue());
        TextFieldWrapper wrapper = new TextFieldWrapper(field, (ITextFieldListener)new TextFieldListener(config));
        this.textFields.add((TextFieldWrapper<? extends GuiTextFieldGeneric>)wrapper);
        this.parent.addTextField(wrapper);
        if (comment != null && !comment.isEmpty()) {
            this.addComment(rect.x(), rect.y(), rect.width(), rect.height(), comment);
        }
        return field;
    }

    protected void addOptionListButton(PositionAlignment alignment, IConfigOptionList config, IButtonActionListener pressListener) {
        this.addOptionListButton(alignment, config, pressListener, ((IConfigBase)config).getComment());
    }

    protected void addOptionListButton(PositionAlignment alignment, IConfigOptionList config, IButtonActionListener pressListener, @Nullable String comment) {
        Rect rect = this.addRect(alignment);
        ConfigButtonOptionList optionButton = new ConfigButtonOptionList(rect.x(), rect.y(), rect.width(), rect.height(), config);
        this.addButton((ButtonBase)optionButton, pressListener);
        this.addCommentForWidget((WidgetBase)optionButton, comment);
    }

    protected void addKeybindButton(PositionAlignment alignment, IHotkey hotkey) {
        this.addKeybindButton(alignment, hotkey, hotkey.getComment());
    }

    protected void addKeybindButton(PositionAlignment alignment, IHotkey hotkey, @Nullable String comment) {
        Rect rect = this.addRect(alignment);
        ConfigButtonKeybind keybindButton = new ConfigButtonKeybind(rect.x(), rect.y(), rect.width(), rect.height(), hotkey.getKeybind(), this.host);
        this.addButton((ButtonBase)keybindButton, (IButtonActionListener)this.host.getButtonPressListener());
        this.addCommentForWidget((WidgetBase)keybindButton, comment);
    }

    protected ButtonGeneric addGenericButton(boolean attachLeft, IGuiIcon icon, IButtonActionListener listener, @Nullable String comment) {
        return this.addGenericButton(new PositionAlignment(attachLeft, icon), icon, listener, comment);
    }

    protected ButtonGeneric addSwitchButton(boolean attachLeft, IGuiIcon icon, boolean on, IButtonActionListener listener, @Nullable String comment) {
        return this.addSwitchButton(new PositionAlignment(attachLeft, icon), icon, on, listener, comment);
    }

    protected ButtonGeneric addGenericButton(PositionAlignment alignment, IGuiIcon icon, IButtonActionListener listener, @Nullable String comment) {
        Rect rect = this.addRect(alignment);
        ButtonGeneric button = (ButtonGeneric)this.addButton((ButtonBase)new ButtonGeneric(rect.x(), rect.y(), icon, new String[0]), listener);
        this.addCommentForWidget((WidgetBase)button, comment);
        return button;
    }

    protected ButtonGeneric addSwitchButton(PositionAlignment alignment, IGuiIcon icon, boolean on, IButtonActionListener listener, @Nullable String comment) {
        Rect rect = this.addRect(alignment);
        ButtonGeneric button = (ButtonGeneric)this.addButton((ButtonBase)new ButtonSwitch(rect.x(), rect.y(), icon, on), listener);
        this.addCommentForWidget((WidgetBase)button, comment);
        return button;
    }

    protected void addCommentForWidget(WidgetBase widget, @Nullable String comment) {
        if (comment != null && !comment.isEmpty()) {
            this.addComment(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), comment);
        }
    }

    protected void addComment(int x, int y, int width, int height, @NotNull String comment) {
        this.addWidget((WidgetBase)new WidgetHoverInfo(x, y, width, height, comment, new Object[0]));
    }

    protected void addLabel(PositionAlignment alignment, int textColor, String ... lines) {
        Rect rect = this.addRect(alignment);
        this.addLabel(rect.x(), rect.y(), rect.width(), rect.height(), textColor, lines);
    }

    public Rect addRect(PositionAlignment alignment) {
        return this.rectContainer.addRect(alignment);
    }

    protected void addLine() {
        this.rectContainer.addLine();
        this.height = this.rectContainer.getHeight();
    }

    protected int maxWidth() {
        return this.rectContainer.maxWidth();
    }

    protected int space() {
        return this.rectContainer.spaceX;
    }

    public boolean wasConfigModified() {
        return false;
    }

    public boolean hasPendingModifications() {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            if (textField.getTextField().method_1882().equals(this.lastAppliedValue)) continue;
            return true;
        }
        return false;
    }

    public void applyNewValueToConfig() {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            textField.onGuiClosed();
            this.lastAppliedValue = textField.getTextField().method_1882();
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (super.isMouseOver(mouseX, mouseY)) {
            return true;
        }
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        boolean ret = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            ret |= textField.getTextField().method_25402((double)mouseX, (double)mouseY, mouseButton);
        }
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                ret |= widget.isMouseOver(mouseX, mouseY) && widget.onMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        return ret;
    }

    public boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            if (!textField.isFocused()) continue;
            if (keyCode == 257) {
                textField.onGuiClosed();
                this.lastAppliedValue = textField.getTextField().method_1882();
                return true;
            }
            return textField.onKeyTyped(keyCode, scanCode, modifiers);
        }
        return false;
    }

    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            if (!textField.onCharTyped(charIn, modifiers)) continue;
            return true;
        }
        return super.onCharTypedImpl(charIn, modifiers);
    }

    public void render(int mouseX, int mouseY, boolean selected, class_332 drawContext) {
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> textField : this.textFields) {
            textField.getTextField().method_25394(drawContext, mouseX, mouseY, 0.0f);
        }
        super.render(mouseX, mouseY, selected, drawContext);
    }
}

