/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui;

import net.smok.macrofactory.gui.PositionAlignment;
import net.smok.macrofactory.gui.Rect;
import org.jetbrains.annotations.NotNull;

public class RectContainer {
    protected final int spaceX;
    protected final int spaceY;
    protected final int minX;
    protected final int maxX;
    protected final int y;
    private final int lineHeight;
    private int minEmptyX;
    private int maxEmptyX;
    private int line;
    private int height;

    public RectContainer(int spaceX, int spaceY, int minX, int maxX, int y, int lineHeight) {
        this.spaceX = spaceX;
        this.spaceY = spaceY;
        this.minX = minX;
        this.maxX = maxX;
        this.y = y;
        this.lineHeight = lineHeight;
        this.minEmptyX = minX;
        this.maxEmptyX = maxX;
        this.height = lineHeight;
    }

    public void addLine() {
        ++this.line;
        this.height = (this.lineHeight + this.spaceY) * (this.line + 1);
        this.minEmptyX = this.minX;
        this.maxEmptyX = this.maxX;
    }

    public void addLines(int amount) {
        this.line += amount;
        this.height = (this.lineHeight + this.spaceY) * (this.line + 1);
        this.minEmptyX = this.minX;
        this.maxEmptyX = this.maxX;
    }

    public int getLineY() {
        return this.y + (this.lineHeight + this.spaceY) * this.line;
    }

    public int getMinY() {
        return this.y;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int maxWidth() {
        return this.maxEmptyX - this.minEmptyX;
    }

    public Rect addRect(@NotNull PositionAlignment alignment) {
        int x;
        int width = alignment.getSize(this.maxWidth());
        if (alignment.isLeft()) {
            x = this.minEmptyX + alignment.shift();
            this.minEmptyX = x + width + this.spaceX;
        } else {
            x = this.maxEmptyX - width - alignment.shift();
            this.maxEmptyX = x - this.spaceX;
        }
        return new Rect(x, this.getLineY(), width, this.lineHeight);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.minX && mouseX < this.maxX && mouseY >= this.y && mouseY < this.y + this.height;
    }

    public int getHeight() {
        return this.height;
    }
}

