/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.macros;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.smok.macrofactory.HotKeyWithCallBack;
import net.smok.macrofactory.PlayerKeybind;
import net.smok.macrofactory.TickLoop;
import net.smok.macrofactory.macros.CallType;
import net.smok.macrofactory.macros.ItemIcon;
import net.smok.macrofactory.macros.Module;
import net.smok.macrofactory.macros.SmokUtils;
import net.smok.macrofactory.macros.actions.ActionType;
import net.smok.macrofactory.macros.actions.CommandAction;
import net.smok.macrofactory.macros.actions.MacroAction;
import net.smok.macrofactory.macros.actions.PlayerAction;
import org.jetbrains.annotations.NotNull;

public class Macro {
    private final ConfigString name = new ConfigString("Name", "", "config.comment.macro_name");
    private final ConfigHotkey hotkey = new HotKeyWithCallBack("Hotkey", "", KeybindSettings.INGAME_BOTH, "config.comment.macro_hotkey", this::onKeyAction);
    private final ConfigOptionList actionType = new ConfigOptionList("Type", (IConfigOptionListEntry)ActionType.Command, "config.comment.type");
    private final ConfigOptionList callType = new ConfigOptionList("Call", (IConfigOptionListEntry)CallType.SINGLE, "config.comment.call");
    private final ConfigInteger delay = new ConfigInteger("Delay", 0, 0, 1200, "config.comment.delay");
    private final ItemIcon icon = new ItemIcon("Icon", class_1799.field_8037, "config.comment.icon");
    private final PlayerAction playerAction = new PlayerAction("Action", "config.comment.player_action");
    private final CommandAction commandAction = new CommandAction("Action", "gui.button.chat", "config.comment.command_action");
    public boolean configure;
    private final Module module;
    private boolean enable;
    private int cd;

    public int getCd() {
        return this.cd;
    }

    public Macro(Module module) {
        this.module = module;
    }

    public Macro(Module module, String name, String defaultHotkeys) {
        this(module);
        this.name.setValueFromString(name);
        this.hotkey.setValueFromString(defaultHotkeys);
    }

    public Macro(Module module, String name, String defaultHotkeys, String firstCommand) {
        this(module);
        this.name.setValueFromString(name);
        this.hotkey.setValueFromString(defaultHotkeys);
        this.commandAction.getCommand().setValueFromString(firstCommand);
        this.actionType.setOptionListValue((IConfigOptionListEntry)ActionType.Command);
    }

    public Macro(Module module, String firstCommand) {
        this(module);
        this.commandAction.getCommand().setValueFromString(firstCommand);
        this.actionType.setOptionListValue((IConfigOptionListEntry)ActionType.Command);
    }

    public Macro(Module module, String name, String defaultHotkeys, boolean looped, int delay, PlayerKeybind playerActionKeybind) {
        this(module);
        this.name.setValueFromString(name);
        this.hotkey.setValueFromString(defaultHotkeys);
        this.delay.setIntegerValue(delay);
        this.callType.setOptionListValue((IConfigOptionListEntry)(looped ? CallType.REPEAT : CallType.SINGLE));
        this.playerAction.setOptionListValue(playerActionKeybind);
        this.actionType.setOptionListValue((IConfigOptionListEntry)ActionType.Player);
    }

    public ConfigHotkey getHotkey() {
        return this.hotkey;
    }

    public IKeybind getKeybind() {
        return this.hotkey.getKeybind();
    }

    public String getName() {
        return this.name.getStringValue();
    }

    public Module getModule() {
        return this.module;
    }

    public PlayerAction getPlayerAction() {
        return this.playerAction;
    }

    public CommandAction getCommandAction() {
        return this.commandAction;
    }

    public ConfigString getNameConfig() {
        return this.name;
    }

    public ConfigOptionList getActionType() {
        return this.actionType;
    }

    public IConfigValue getDelayConfig() {
        return this.delay;
    }

    public ConfigOptionList getCallType() {
        return this.callType;
    }

    public ItemIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getSelectName() {
        if (!this.name.getStringValue().isEmpty()) {
            return this.name.getStringValue();
        }
        switch ((ActionType)this.actionType.getOptionListValue()) {
            case Player: {
                return this.playerAction.getOptionListValue().getDisplayName();
            }
            case Command: {
                return this.commandAction.getCommand().getStringValue();
            }
        }
        return "";
    }

    public JsonElement getAsJsonElement() {
        JsonObject json = new JsonObject();
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.name);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.hotkey);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.delay);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.actionType);
        SmokUtils.getAsJsonElement(json, (IConfigBase)this.callType);
        SmokUtils.getAsJsonElement(json, this.icon);
        switch ((ActionType)this.actionType.getOptionListValue()) {
            case Player: {
                SmokUtils.getAsJsonElement(json, (IConfigBase)this.playerAction);
                break;
            }
            case Command: {
                json.add(this.commandAction.getName(), this.commandAction.getAsJsonElement());
            }
        }
        return json;
    }

    public void setValueFromJsonElement(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.name);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.hotkey);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.delay);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.actionType);
        SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.callType);
        SmokUtils.setValueFromJsonElement(json, this.icon);
        switch ((ActionType)this.actionType.getOptionListValue()) {
            case Player: {
                SmokUtils.setValueFromJsonElement(json, (IConfigBase)this.playerAction);
                break;
            }
            case Command: {
                this.commandAction.setValueFromJsonElement(json.get(this.commandAction.getName()));
            }
        }
    }

    private boolean onKeyAction(KeyAction keyAction, IKeybind key) {
        class_310 client = class_310.method_1551();
        this.macroExecute(keyAction == KeyAction.PRESS, client);
        return true;
    }

    public void macroExecute(boolean press, @NotNull class_310 client) {
        switch ((CallType)this.callType.getOptionListValue()) {
            case SINGLE: {
                if (press) break;
                this.getAction().run(client, MacroAction.Loop.TICK, this);
                break;
            }
            case REPEAT: {
                if (press) break;
                if (this.enable) {
                    TickLoop.removeFromLoop(this);
                    break;
                }
                this.startLoop(client);
                TickLoop.addToLoop(this);
                break;
            }
            case HOLD: {
                if (press) {
                    this.startLoop(client);
                    TickLoop.addToLoop(this);
                    break;
                }
                TickLoop.removeFromLoop(this);
            }
        }
    }

    public void tickLoop(class_310 client) {
        if (this.cd <= 0) {
            this.cd += this.delay.getIntegerValue();
            this.getAction().run(client, MacroAction.Loop.TICK, this);
        } else {
            this.getAction().run(client, MacroAction.Loop.OFF_TICK, this);
        }
        if (this.cd > 0) {
            --this.cd;
        }
    }

    public void startLoop(class_310 client) {
        this.enable = true;
        this.getAction().run(client, MacroAction.Loop.START, this);
    }

    public void endLoop(class_310 client) {
        this.enable = false;
        this.getAction().run(client, MacroAction.Loop.END, this);
    }

    private MacroAction getAction() {
        return switch ((ActionType)this.actionType.getOptionListValue()) {
            default -> throw new MatchException(null, null);
            case ActionType.Player -> this.playerAction;
            case ActionType.Command -> this.commandAction;
        };
    }
}

