/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_437;
import net.smok.macrofactory.HotKeyWithCallBack;
import net.smok.macrofactory.MacroFactory;
import net.smok.macrofactory.PlayerKeybind;
import net.smok.macrofactory.gui.modules.ModulesGui;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.Module;

public class Configs
implements IConfigHandler,
IKeybindProvider {
    public static final Configs INSTANCE = new Configs();
    private static final String CONFIG_FILE_NAME = "macrofactory.json";
    private static final String MACRO_DIR = "macrofactory_macros";

    public void addKeysToMap(IKeybindManager manager) {
        manager.addKeybindToMap(Generic.CMD_MACRO_OPEN.getKeybind());
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("macrofactory", "autoMacro.test", (List)ImmutableList.of((Object)Generic.CMD_MACRO_OPEN));
    }

    public void load() {
        Configs.readGeneric();
        Configs.readMacros();
    }

    private static void readGeneric() {
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (!(configFile.exists() && configFile.isFile() && configFile.canRead())) {
            return;
        }
        JsonElement element = JsonUtils.parseJsonFile((File)configFile);
        if (element == null || !element.isJsonObject()) {
            return;
        }
        JsonObject root = element.getAsJsonObject();
        try {
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
        }
        catch (Exception ignored) {
            MacroFactory.LOGGER.info("Corrupted Options file. ");
        }
    }

    private static void readMacros() {
        File macrosDir = new File(FileUtils.getConfigDirectory(), MACRO_DIR);
        if (!macrosDir.exists() || !macrosDir.isDirectory()) {
            return;
        }
        File[] files = macrosDir.listFiles(pathname -> pathname.getName().endsWith(".json"));
        if (files == null) {
            return;
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        for (File moduleFile : files) {
            if (!moduleFile.exists() || !moduleFile.isFile() || !moduleFile.canRead()) continue;
            try {
                JsonElement element = JsonUtils.parseJsonFile((File)moduleFile);
                if (element == null || !element.isJsonObject()) continue;
                Module module = new Module();
                module.setValueFromJsonElement(element);
                modules.add(module);
            }
            catch (Exception e) {
                MacroFactory.LOGGER.info("Corrupted Options file. \n" + e.getLocalizedMessage());
            }
        }
        Macros.Modules = modules;
    }

    public void save() {
        File dir = FileUtils.getConfigDirectory();
        Configs.writeGeneric(dir);
        Configs.writeMacros(dir);
    }

    private static void writeGeneric(File dir) {
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject genericJson = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)genericJson, (String)"Generic", Generic.OPTIONS);
            JsonUtils.writeJsonToFile((JsonObject)genericJson, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    private static void writeMacros(File dir) {
        File macrosDir = new File(dir, MACRO_DIR);
        if (!(macrosDir.exists() && macrosDir.isDirectory() || macrosDir.mkdirs())) {
            return;
        }
        File[] files = macrosDir.listFiles(pathname -> pathname.getName().endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (Module module : Macros.Modules) {
            int n = 0;
            if (count.containsKey(module.getName())) {
                n = (Integer)count.get(module.getName());
            }
            count.put(module.getName(), n + 1);
            if (n == 0) {
                JsonUtils.writeJsonToFile((JsonObject)module.getAsJsonElement(), (File)new File(macrosDir, module.getName() + ".json"));
                continue;
            }
            JsonUtils.writeJsonToFile((JsonObject)module.getAsJsonElement(), (File)new File(macrosDir, module.getName() + n + ".json"));
        }
    }

    public static class Generic {
        public static final ConfigHotkey CMD_MACRO_OPEN = new HotKeyWithCallBack("cmdMacroOpen", "Y", "Menu Open", (action, key) -> {
            GuiBase.openGui((class_437)new ModulesGui(null));
            return true;
        });
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)CMD_MACRO_OPEN);
    }

    public static class Macros {
        public static List<Module> Modules;

        static {
            Module creative = new Module("module.default.default");
            creative.add(new Macro(creative, StringUtils.translate((String)"macro.default.sample_command", (Object[])new Object[0]), "KP_7", "/say Hello World!"));
            creative.add(new Macro(creative, StringUtils.translate((String)"macro.default.auto_use", (Object[])new Object[0]), "KP_8", true, 0, PlayerKeybind.USE));
            creative.add(new Macro(creative, StringUtils.translate((String)"macro.default.auto_attack", (Object[])new Object[0]), "KP_9", true, 20, PlayerKeybind.ATTACK));
            Modules = new ArrayList<Module>();
            Modules.add(creative);
        }
    }
}

