/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.function.Function;
import net.minecraft.class_304;
import net.minecraft.class_310;

public enum PlayerKeybind implements IConfigOptionListEntry
{
    FORWARD(client -> client.field_1690.field_1894),
    JUMP(client -> client.field_1690.field_1903),
    USE(client -> client.field_1690.field_1904),
    ATTACK(client -> client.field_1690.field_1886),
    BACK(client -> client.field_1690.field_1881),
    SNEAK(client -> client.field_1690.field_1832);

    private final Function<class_310, class_304> keyBindingGetter;

    private PlayerKeybind(Function<class_310, class_304> keyBindingGetter) {
        this.keyBindingGetter = keyBindingGetter;
    }

    public void setPressed(class_310 client, boolean pressed) {
        this.keyBindingGetter.apply(client).method_23481(pressed);
    }

    public boolean isPressed(class_310 client) {
        return this.keyBindingGetter.apply(client).method_1434();
    }

    public boolean wasPressed(class_310 client) {
        return this.keyBindingGetter.apply(client).method_1436();
    }

    public String getStringValue() {
        return this.name();
    }

    public String getDisplayName() {
        return StringUtils.translate((String)("key." + this.name().toLowerCase()), (Object[])new Object[0]);
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        return forward ? PlayerKeybind.cycleForward(this) : PlayerKeybind.cycleBackward(this);
    }

    public IConfigOptionListEntry fromString(String value) {
        return PlayerKeybind.valueOf(value);
    }

    private static PlayerKeybind cycleForward(PlayerKeybind keybind) {
        return switch (keybind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BACK;
            case 4 -> SNEAK;
            case 5 -> JUMP;
            case 1 -> USE;
            case 2 -> ATTACK;
            case 3 -> FORWARD;
        };
    }

    private static PlayerKeybind cycleBackward(PlayerKeybind keybind) {
        return switch (keybind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ATTACK;
            case 4 -> FORWARD;
            case 5 -> BACK;
            case 1 -> SNEAK;
            case 2 -> JUMP;
            case 3 -> USE;
        };
    }
}

