/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui;

import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface FilteredEntry {
    public boolean isFiltered(String var1, IKeybind var2, boolean var3);

    default public boolean isVisibleContent() {
        return true;
    }

    public List<String> getStringsForFilter();

    @NotNull
    public static FilteredEntry convert(Object entry) {
        FilteredEntry filteredEntry;
        if (entry instanceof FilteredEntry) {
            filteredEntry = (FilteredEntry)entry;
        } else if (entry instanceof IConfigBase) {
            IConfigBase configEntry = (IConfigBase)entry;
            filteredEntry = FilteredEntry.convert(configEntry);
        } else if (entry instanceof GuiConfigsBase.ConfigOptionWrapper) {
            GuiConfigsBase.ConfigOptionWrapper wrapperEntry = (GuiConfigsBase.ConfigOptionWrapper)entry;
            filteredEntry = FilteredEntry.convert(wrapperEntry);
        } else {
            return FilteredEntry.empty();
        }
        return filteredEntry;
    }

    @NotNull
    public static FilteredEntry convert(@NotNull GuiConfigsBase.ConfigOptionWrapper wrapper) {
        return wrapper.getConfig() != null ? FilteredEntry.convert(wrapper.getConfig()) : FilteredEntry.empty();
    }

    @NotNull
    public static FilteredEntry empty() {
        return new FilteredEntry(){

            @Override
            public boolean isFiltered(String filterText, IKeybind filterKeys, boolean entryMatchesFilter) {
                return filterText.isEmpty() || entryMatchesFilter;
            }

            @Override
            public List<String> getStringsForFilter() {
                return Collections.emptyList();
            }
        };
    }

    @NotNull
    public static FilteredEntry convert(final @NotNull IConfigBase config) {
        return new FilteredEntry(){

            @Override
            public boolean isFiltered(String filterText, IKeybind filterKeys, boolean entryMatchesFilter) {
                return filterText.isEmpty() || entryMatchesFilter && (config.getType() != ConfigType.HOTKEY || filterKeys.getKeys().isEmpty() || ((IHotkey)config).getKeybind().overlaps(filterKeys));
            }

            @Override
            public List<String> getStringsForFilter() {
                ArrayList<String> list = new ArrayList<String>();
                String name = config.getName();
                String translated = config.getConfigGuiDisplayName();
                list.add(name.toLowerCase());
                if (!name.equals(translated)) {
                    list.add(translated.toLowerCase());
                }
                if (config instanceof IConfigResettable && ((IConfigResettable)config).isModified()) {
                    list.add("modified");
                }
                return list;
            }
        };
    }
}

