/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui.modules;

import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import net.smok.macrofactory.gui.GuiEntry;
import net.smok.macrofactory.gui.GuiList;
import net.smok.macrofactory.gui.MacroIcons;
import net.smok.macrofactory.gui.PositionAlignment;
import net.smok.macrofactory.gui.modules.ModuleWrapper;
import net.smok.macrofactory.gui.selector.ItemIconWidget;
import net.smok.macrofactory.gui.utils.ListEntryBox;
import net.smok.macrofactory.macros.CallType;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.actions.ActionType;
import net.smok.macrofactory.macros.actions.CommandAction;

public class MacroEntry
extends GuiEntry<ModuleWrapper> {
    private static final String BUTTON_MACRO_REMOVE = "gui.button.macro_remove";
    private static final String BUTTON_MACRO_CONFIGURE = "gui.button.macro_configure";
    private ButtonGeneric inChatButton;
    private GuiTextFieldGeneric delayText;

    public MacroEntry(int x, int y, int width, int lineHeight, int space, GuiList<?, ?> parent, ModuleWrapper entry, int listIndex, IKeybindConfigGui host) {
        super(x, y, width, lineHeight, space, parent, entry, listIndex, host);
    }

    @Override
    public void init() {
        Macro macro = ModuleWrapper.getMacro((ModuleWrapper)this.entry);
        if (macro == null) {
            return;
        }
        this.addGenericButton(new PositionAlignment(false, MacroIcons.MACRO_REMOVE), (IGuiIcon)MacroIcons.MACRO_REMOVE, this::removeMacro, BUTTON_MACRO_REMOVE);
        this.addSwitchButton(new PositionAlignment(false, MacroIcons.SETTINGS), (IGuiIcon)MacroIcons.SETTINGS, macro.configure, this::openConfigure, BUTTON_MACRO_CONFIGURE);
        this.addKeybindButton(new PositionAlignment(false, 120), (IHotkey)macro.getHotkey());
        if (macro.configure) {
            this.addTextField(new PositionAlignment(true, 120), (IConfigValue)macro.getNameConfig(), 30);
        } else {
            String name = macro.getNameConfig().getStringValue();
            if (!name.isEmpty()) {
                this.addLabel(new PositionAlignment(true, 115, 5), -1, name);
            }
        }
        ActionType actionType = (ActionType)macro.getActionType().getOptionListValue();
        switch (actionType) {
            case Command: {
                CommandAction config = macro.getCommandAction();
                this.inChatButton = this.addSwitchButton(false, (IGuiIcon)MacroIcons.CHAT, config.getInChat().getBooleanValue(), config::switchInChat, config.getInChat().getComment());
                this.addTextField(new PositionAlignment(true), (IConfigValue)config.getCommand(), 256);
                break;
            }
            case Player: {
                this.addOptionListButton(new PositionAlignment(true, 200), (IConfigOptionList)macro.getPlayerAction(), (IButtonActionListener)this.host.getButtonPressListener(), macro.getPlayerAction().getComment());
            }
        }
        if (macro.configure) {
            this.addLine();
            ButtonGeneric iconButton = this.addGenericButton(true, (IGuiIcon)MacroIcons.MACRO_EMPTY_BUTTON, macro.getIcon()::setIconFromHand, macro.getIcon().getComment());
            this.addWidget(new ItemIconWidget(iconButton.getX(), iconButton.getY(), iconButton.getWidth(), iconButton.getHeight(), macro.getIcon(), MacroIcons.MACRO_EMPTY_ICON));
            this.delayText = this.addTextField(new PositionAlignment(false, 40 + this.space()), macro.getDelayConfig(), 4);
            this.addOptionListButton(new PositionAlignment(false, 120), (IConfigOptionList)macro.getCallType(), this::changeCallType);
            this.addOptionListButton(new PositionAlignment(true, 200), (IConfigOptionList)macro.getActionType(), this::changeActionType);
            this.addWidget(new ListEntryBox(this.x - 2, this.y + this.height - 1, this.getWidth(), 1, false, true));
        }
        this.changeButtonsByCallType(macro);
        this.addWidget(new ListEntryBox(this.x - 2, this.y - 1, 1, this.getHeight() + 1, true, false));
    }

    private void changeCallType(ButtonBase buttonBase, int mouseButton) {
        Macro macro = ModuleWrapper.getMacro((ModuleWrapper)this.entry);
        if (mouseButton == 0 && macro != null) {
            this.changeButtonsByCallType(macro);
        }
    }

    private void changeButtonsByCallType(Macro macro) {
        boolean single;
        boolean bl = single = macro.getCallType().getOptionListValue() == CallType.SINGLE;
        if (this.inChatButton != null) {
            this.inChatButton.setEnabled(single);
            if (!single) {
                macro.getCommandAction().getInChat().setBooleanValue(false);
            }
        }
        if (this.delayText != null) {
            this.delayText.method_1888(!single);
            if (single) {
                this.delayText.method_25365(false);
            }
        }
    }

    private void changeActionType(ButtonBase button, int mouseButton) {
        this.parent.refreshEntries();
    }

    private void openConfigure(ButtonBase button, int mouseButton) {
        Macro macro = ModuleWrapper.getMacro((ModuleWrapper)this.entry);
        if (mouseButton == 0 && macro != null) {
            macro.configure = !macro.configure;
            this.parent.refreshEntries();
        }
    }

    private void removeMacro(ButtonBase button, int mouseButton) {
        Macro macro = ModuleWrapper.getMacro((ModuleWrapper)this.entry);
        if (mouseButton == 0 && macro != null) {
            if (macro.getModule() != null) {
                macro.getModule().remove(macro);
            }
            this.parent.refreshEntries();
        }
    }
}

