/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui.modules;

import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import net.smok.macrofactory.Configs;
import net.smok.macrofactory.gui.ButtonSwitch;
import net.smok.macrofactory.gui.GuiEntry;
import net.smok.macrofactory.gui.GuiList;
import net.smok.macrofactory.gui.MacroIcons;
import net.smok.macrofactory.gui.PositionAlignment;
import net.smok.macrofactory.gui.modules.ModuleWrapper;
import net.smok.macrofactory.gui.utils.ListEntryBox;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.Module;

public class ModuleEntry
extends GuiEntry<ModuleWrapper> {
    private static final String BUTTON_MACRO_ADD = "gui.button.macro_add";
    private static final String BUTTON_MODULE_REMOVE = "gui.button.module_remove";
    private static final String BUTTON_MODULE_CONFIGURE = "gui.button.module_configure";
    private static final String BUTTON_MODULE_OPEN = "gui.button.module_open";
    private static final String BUTTON_MODULE_ENABLED = "gui.button.module_enabled";

    public ModuleEntry(int x, int y, int width, int height, int space, GuiList<?, ?> parent, ModuleWrapper entry, int listIndex, IKeybindConfigGui host) {
        super(x, y, width, height, space, parent, entry, listIndex, host);
    }

    @Override
    public void init() {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (module == null) {
            return;
        }
        this.addGenericButton(false, (IGuiIcon)MacroIcons.FOLDER_REMOVE, this::removeThisCollection, BUTTON_MODULE_REMOVE);
        this.addGenericButton(false, (IGuiIcon)MacroIcons.MACRO_ADD, this::addNewMacro, BUTTON_MACRO_ADD);
        this.addSwitchButton(false, (IGuiIcon)MacroIcons.SETTINGS, module.configure, this::openConfigure, BUTTON_MODULE_CONFIGURE);
        this.addSwitchButton(false, (IGuiIcon)MacroIcons.ENABLED, module.getEnabled().getBooleanValue(), this::enableOrDisable, BUTTON_MODULE_ENABLED);
        this.addSwitchButton(true, (IGuiIcon)MacroIcons.FOLDER, module.isOpen, this::openOrCloseFolder, BUTTON_MODULE_OPEN);
        if (module.configure) {
            this.addTextField(new PositionAlignment(true), (IConfigValue)module.getNameConfig(), 30);
        } else {
            String name = module.getNameConfig().getStringValue();
            if (!name.isEmpty()) {
                this.addLabel(new PositionAlignment(true, Integer.MAX_VALUE, 5), -1, name);
            }
        }
        if (module.configure) {
            this.addLine();
            this.addKeybindButton(new PositionAlignment(false, 120), (IHotkey)module.getGuiKeybind());
        }
        this.addWidget(new ListEntryBox(this.x - 2, this.y + this.height - 1, this.getWidth(), 1, false, true));
    }

    private void openConfigure(ButtonBase button, int mouseButton) {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (mouseButton == 0 && this.entry != null) {
            module.configure = !module.configure;
            this.parent.refreshEntries();
        }
    }

    private void removeThisCollection(ButtonBase button, int mouseButton) {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (mouseButton == 0 && module != null) {
            Configs.Macros.Modules.remove(module);
            this.parent.refreshEntries();
        }
    }

    private void addNewMacro(ButtonBase button, int mouseButton) {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (mouseButton == 0 && module != null) {
            module.add(new Macro(module, "Hello world!"));
            this.parent.refreshEntries();
        }
    }

    private void enableOrDisable(ButtonBase button, int mouseButton) {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (mouseButton == 0 && module != null) {
            boolean enabled = !module.getEnabled().getBooleanValue();
            module.getEnabled().setBooleanValue(enabled);
            if (button instanceof ButtonSwitch) {
                ButtonSwitch buttonSwitch = (ButtonSwitch)button;
                buttonSwitch.setOn(enabled);
            }
        }
    }

    private void openOrCloseFolder(ButtonBase button, int mouseButton) {
        Module module = ModuleWrapper.getModule((ModuleWrapper)this.entry);
        if (mouseButton == 0 && module != null) {
            boolean bl = module.isOpen = !module.isOpen;
            if (button instanceof ButtonSwitch) {
                ButtonSwitch buttonSwitch = (ButtonSwitch)button;
                buttonSwitch.setOn(!module.isOpen);
            }
            this.parent.refreshEntries();
        }
    }
}

