/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.gui.modules;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import java.util.Collections;
import java.util.List;
import net.smok.macrofactory.gui.FilteredEntry;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.Module;

public final class ModuleWrapper
implements FilteredEntry {
    private final Module module;
    private final Macro macro;
    private final Type type;

    public ModuleWrapper(Module module) {
        this.module = module;
        this.macro = null;
        this.type = Type.MODULE;
    }

    public ModuleWrapper(Macro macro) {
        this.macro = macro;
        this.module = null;
        this.type = Type.MACRO;
    }

    public Type getType() {
        return this.type;
    }

    public static Module getModule(ModuleWrapper wrapper) {
        if (wrapper != null && wrapper.type == Type.MODULE) {
            return wrapper.module;
        }
        return null;
    }

    public static Macro getMacro(ModuleWrapper wrapper) {
        if (wrapper != null && wrapper.type == Type.MACRO) {
            return wrapper.macro;
        }
        return null;
    }

    @Override
    public boolean isFiltered(String filterText, IKeybind filterKeys, boolean entryMatchesFilter) {
        switch (this.type.ordinal()) {
            case 0: {
                return filterText.isEmpty() ? this.macro != null && this.macro.getModule().isOpen : entryMatchesFilter;
            }
            case 1: {
                return filterText.isEmpty() || entryMatchesFilter;
            }
        }
        return true;
    }

    @Override
    public List<String> getStringsForFilter() {
        switch (this.type.ordinal()) {
            case 0: {
                if (this.macro == null) break;
                return ImmutableList.of((Object)this.macro.getName().toLowerCase(), (Object)this.macro.getCommandAction().getCommand().getStringValue().toLowerCase());
            }
            case 1: {
                if (this.module == null) break;
                return ImmutableList.of((Object)this.module.getName().toLowerCase(), (Object)(this.module.getEnabled().getBooleanValue() ? "enabled" : "disabled"));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isVisibleContent() {
        return this.type != Type.MACRO || this.macro != null && this.macro.getModule().isOpen;
    }

    public static enum Type {
        MACRO,
        MODULE;

    }
}

