/*
 * Decompiled with CFR 0.152.
 */
package net.smok.macrofactory.macros.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.smok.macrofactory.gui.ButtonSwitch;
import net.smok.macrofactory.macros.Macro;
import net.smok.macrofactory.macros.SmokUtils;
import net.smok.macrofactory.macros.actions.MacroAction;
import org.jetbrains.annotations.NotNull;

public class CommandAction
implements MacroAction {
    private final ConfigBoolean inChat;
    private final ConfigString command;
    private final String name;

    public CommandAction(String name, String inChatComment, String commandComment) {
        this.name = name;
        this.inChat = new ConfigBoolean("In Chat", false, inChatComment);
        this.command = new ConfigString("Command", "Hello world!", commandComment);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        SmokUtils.setValueFromJsonElement(object, (IConfigBase)this.inChat);
        SmokUtils.setValueFromJsonElement(object, (IConfigBase)this.command);
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonObject object = new JsonObject();
        SmokUtils.getAsJsonElement(object, (IConfigBase)this.inChat);
        SmokUtils.getAsJsonElement(object, (IConfigBase)this.command);
        return object;
    }

    public String getName() {
        return this.name;
    }

    public ConfigBoolean getInChat() {
        return this.inChat;
    }

    public void switchInChat(ButtonBase button, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        this.inChat.setBooleanValue(!this.inChat.getBooleanValue());
        if (button instanceof ButtonSwitch) {
            ButtonSwitch buttonSwitch = (ButtonSwitch)button;
            buttonSwitch.setOn(this.inChat.getBooleanValue());
        }
    }

    public ConfigString getCommand() {
        return this.command;
    }

    @Override
    public void run(@NotNull class_310 client, MacroAction.Loop loop, Macro macro) {
        class_746 player = client.field_1724;
        if (player == null || loop == MacroAction.Loop.OFF_TICK || loop == MacroAction.Loop.END) {
            return;
        }
        if (this.inChat.getBooleanValue()) {
            GuiBase.openGui((class_437)new class_408(this.substringValue()));
        } else {
            this.sendMessageOrCommand(player, this.substringValue());
        }
    }

    private String substringValue() {
        String value = this.command.getStringValue();
        return value.length() > 256 ? value.substring(0, 256) : value;
    }

    private void sendMessageOrCommand(class_746 player, String message) {
        if (message.startsWith("/")) {
            player.field_3944.method_45730(message.substring(1));
        } else {
            player.field_3944.method_45729(message);
        }
    }
}

